/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.keydb.wait;

import com.playtika.testcontainer.common.checks.AbstractRetryingWaitStrategy;
import com.playtika.testcontainer.keydb.KeyDbProperties;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.ContainerLaunchException;
import redis.clients.jedis.Jedis;

public class KeyDbClusterStatusCheck
extends AbstractRetryingWaitStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeyDbClusterStatusCheck.class);
    private final KeyDbProperties properties;

    protected void waitUntilReady() {
        try {
            super.waitUntilReady();
        }
        catch (ContainerLaunchException e) {
            this.logClusterInfo();
            throw e;
        }
    }

    protected boolean isReady() {
        try (Jedis jedis = this.createJedis();){
            String clusterInfo = jedis.clusterInfo();
            boolean bl = clusterInfo.contains("cluster_state:ok");
            return bl;
        }
    }

    private void logClusterInfo() {
        try (Jedis jedis = this.createJedis();){
            String clusterInfo = jedis.clusterInfo();
            String info = jedis.info();
            Map config = jedis.configGet("*");
            String clusterNodes = jedis.clusterNodes();
            log.error("Cluster in failed state:\n-- cluster info:\n{}\n-- nodes:\n{}\n-- info:\n{}\n-- config:\n{}", new Object[]{clusterInfo, clusterNodes, info, String.join((CharSequence)"\n", config.values())});
        }
    }

    private Jedis createJedis() {
        Jedis jedis = new Jedis(this.properties.host, this.properties.port);
        if (this.properties.requirepass) {
            jedis.auth(this.properties.password);
        }
        return jedis;
    }

    @Generated
    public KeyDbClusterStatusCheck(KeyDbProperties properties) {
        this.properties = properties;
    }
}

