/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.keydb;

import com.playtika.testcontainer.common.properties.InstallPackageProperties;
import com.playtika.testcontainer.common.utils.ApkPackageInstaller;
import com.playtika.testcontainer.common.utils.PackageInstaller;
import com.playtika.testcontainer.keydb.KeyDbProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.testcontainers.containers.GenericContainer;

@AutoConfiguration
@ConditionalOnBean(value={KeyDbProperties.class})
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@ConditionalOnProperty(value={"embedded.keydb.enabled"}, matchIfMissing=true)
public class EmbeddedKeyDbTestOperationsAutoConfiguration {
    @Bean(value={"keyDbPackageProperties"})
    @ConfigurationProperties(value="embedded.keydb.install")
    public InstallPackageProperties keyDbPackageProperties() {
        return new InstallPackageProperties();
    }

    @Bean
    public PackageInstaller keyDbPackageInstaller(@Qualifier(value="keyDbPackageProperties") InstallPackageProperties keyDbPackageProperties, @Qualifier(value="embeddedKeyDb") GenericContainer<?> keyDb) {
        return new ApkPackageInstaller(keyDbPackageProperties, keyDb);
    }
}

