/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.keydb;

import com.playtika.testcontainer.keydb.KeyDbProperties;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;

public final class EnvUtils {
    static Map<String, Object> registerKeyDbEnvironment(ConfigurableEnvironment environment, GenericContainer<?> keyDb, KeyDbProperties properties, int port) {
        String host = keyDb.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.keydb.port", port);
        map.put("embedded.keydb.host", host);
        map.put("embedded.keydb.password", properties.getPassword());
        map.put("embedded.keydb.user", properties.getUser());
        map.put("embedded.keydb.networkAlias", "keydb.testcontainer.docker");
        MapPropertySource propertySource = new MapPropertySource("embeddedKeyDbInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        return map;
    }

    private EnvUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

