/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.localstack;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.localstack.LocalStackProperties;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.localstack.LocalStackContainer;
import org.testcontainers.utility.DockerImageName;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.localstack.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={LocalStackProperties.class})
public class EmbeddedLocalStackBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedLocalStackBootstrapConfiguration.class);

    @ConditionalOnMissingBean(name={"embeddedLocalstack"})
    @Bean(name={"embeddedLocalstack"}, destroyMethod="stop")
    public EmbeddedLocalStackContainer localStack(ConfigurableEnvironment environment, LocalStackProperties properties) {
        log.info("Starting Localstack server. Docker image: {}", (Object)properties.dockerImage);
        EmbeddedLocalStackContainer localStackContainer = new EmbeddedLocalStackContainer(properties.dockerImage);
        ((LocalStackContainer)((LocalStackContainer)((LocalStackContainer)((LocalStackContainer)((LocalStackContainer)localStackContainer.withExposedPorts(new Integer[]{properties.getEdgePort()})).withEnv("EDGE_PORT", String.valueOf(properties.getEdgePort()))).withEnv("DEFAULT_REGION", properties.getDefaultRegion())).withEnv("HOSTNAME", properties.getHostname())).withEnv("HOSTNAME_EXTERNAL", properties.getHostnameExternal())).withEnv("USE_SSL", String.valueOf(properties.isUseSsl()));
        for (LocalStackContainer.Service service : properties.services) {
            localStackContainer.withServices(new LocalStackContainer.Service[]{service});
        }
        localStackContainer = (EmbeddedLocalStackContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)localStackContainer, (CommonContainerProperties)properties, (Logger)log);
        this.registerLocalStackEnvironment(localStackContainer, environment, properties);
        return localStackContainer;
    }

    private void registerLocalStackEnvironment(EmbeddedLocalStackContainer localStack, ConfigurableEnvironment environment, LocalStackProperties properties) {
        String host = localStack.getContainerIpAddress();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.localstack.host", host);
        map.put("embedded.localstack.accessKey", localStack.getAccessKey());
        map.put("embedded.localstack.secretKey", localStack.getSecretKey());
        map.put("embedded.localstack.region", localStack.getRegion());
        String prefix = "embedded.localstack.";
        Integer mappedPort = localStack.getMappedPort(properties.getEdgePort());
        for (LocalStackContainer.Service service : properties.services) {
            map.put(prefix + service, localStack.getEndpointConfiguration(service).getServiceEndpoint());
            map.put(prefix + service + ".port", mappedPort);
        }
        log.info("Started Localstack. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedLocalStackInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        EmbeddedLocalStackBootstrapConfiguration.setSystemProperties(localStack);
    }

    private static void setSystemProperties(EmbeddedLocalStackContainer localStack) {
        System.setProperty("aws.accessKeyId", localStack.getAccessKey());
        System.setProperty("aws.secretKey", localStack.getAccessKey());
    }

    private static class EmbeddedLocalStackContainer
    extends LocalStackContainer {
        EmbeddedLocalStackContainer(String dockerImageName) {
            super(DockerImageName.parse((String)dockerImageName));
        }
    }
}

