/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.localstack;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.localstack.LocalStackProperties;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.localstack.LocalStackContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.localstack.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={LocalStackProperties.class})
public class EmbeddedLocalStackBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedLocalStackBootstrapConfiguration.class);
    private static final String LOCALSTACK_NETWORK_ALIAS = "localstack.testcontainer.docker";

    @Bean
    @ConditionalOnToxiProxyEnabled(module="localstack")
    ToxiproxyContainer.ContainerProxy localstackContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedLocalstack") LocalStackContainer localStack, LocalStackProperties properties, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy((GenericContainer)localStack, properties.getEdgePort());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.localstack.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.localstack.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.localstack.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedLocalstackToxiproxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started Localstack ToxiProxy connection details {}", map);
        return proxy;
    }

    @ConditionalOnMissingBean(name={"embeddedLocalstack"})
    @Bean(name={"embeddedLocalstack"}, destroyMethod="stop")
    public LocalStackContainer localStack(ConfigurableEnvironment environment, LocalStackProperties properties, Optional<Network> network) {
        LocalStackContainer localStackContainer = new LocalStackContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties));
        ((LocalStackContainer)((LocalStackContainer)((LocalStackContainer)((LocalStackContainer)((LocalStackContainer)localStackContainer.withExposedPorts(new Integer[]{properties.getEdgePort()})).withEnv("EDGE_PORT", String.valueOf(properties.getEdgePort()))).withEnv("HOSTNAME", properties.getHostname())).withEnv("LOCALSTACK_HOST", properties.getHostnameExternal())).withEnv("SKIP_SSL_CERT_DOWNLOAD", "1")).withNetworkAliases(new String[]{LOCALSTACK_NETWORK_ALIAS});
        network.ifPresent(arg_0 -> ((LocalStackContainer)localStackContainer).withNetwork(arg_0));
        for (LocalStackContainer.Service service : properties.services) {
            localStackContainer.withServices(new LocalStackContainer.Service[]{service});
        }
        localStackContainer = (LocalStackContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)localStackContainer, (CommonContainerProperties)properties, (Logger)log);
        this.registerLocalStackEnvironment(localStackContainer, environment, properties);
        return localStackContainer;
    }

    private void registerLocalStackEnvironment(LocalStackContainer localStack, ConfigurableEnvironment environment, LocalStackProperties properties) {
        String host = localStack.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.localstack.host", host);
        map.put("embedded.localstack.accessKey", localStack.getAccessKey());
        map.put("embedded.localstack.secretKey", localStack.getSecretKey());
        map.put("embedded.localstack.networkAlias", LOCALSTACK_NETWORK_ALIAS);
        map.put("embedded.localstack.internalEdgePort", properties.getEdgePort());
        String prefix = "embedded.localstack.";
        Integer mappedPort = localStack.getMappedPort(properties.getEdgePort());
        for (LocalStackContainer.Service service : properties.services) {
            map.put(prefix + service, localStack.getEndpointOverride(service));
            map.put(prefix + service + ".port", mappedPort);
        }
        log.info("Started Localstack. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedLocalStackInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        EmbeddedLocalStackBootstrapConfiguration.setSystemProperties(localStack);
    }

    private static void setSystemProperties(LocalStackContainer localStack) {
        System.setProperty("aws.accessKeyId", localStack.getAccessKey());
        System.setProperty("aws.secretKey", localStack.getAccessKey());
    }
}

