/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.mailhog;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.mailhog.MailHogProperties;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.util.LinkedHashMap;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.mailhog.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={MailHogProperties.class})
public class EmbeddedMailHogBootstrapConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedMailHogBootstrapConfiguration.class);
    private static final String MAILHOG_NETWORK_ALIAS = "mailhog.testcontainer.docker";

    @Bean
    @ConditionalOnToxiProxyEnabled(module="mailhog")
    ToxiproxyContainer.ContainerProxy mailhogSmtpContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedMailHog") GenericContainer<?> mailhogContainer, MailHogProperties properties, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy(mailhogContainer, properties.getSmtpPort().intValue());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.mailhog.smtp.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.mailhog.smtp.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.mailhog.smtp.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedMailhogSmtpToxiproxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started MailHog SMTP ToxiProxy connection details {}", map);
        return proxy;
    }

    @ConditionalOnMissingBean(name={"embeddedMailHog"})
    @Bean(name={"embeddedMailHog"}, destroyMethod="stop")
    public GenericContainer<?> mailHog(ConfigurableEnvironment environment, MailHogProperties properties, Optional<Network> network) {
        GenericContainer mailHog = new GenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withExposedPorts(new Integer[]{properties.getSmtpPort(), properties.getHttpPort()}).withNetworkAliases(new String[]{MAILHOG_NETWORK_ALIAS}).waitingFor((WaitStrategy)Wait.forListeningPort());
        network.ifPresent(arg_0 -> ((GenericContainer)mailHog).withNetwork(arg_0));
        mailHog = ContainerUtils.configureCommonsAndStart((GenericContainer)mailHog, (CommonContainerProperties)properties, (Logger)log);
        this.registerMailHogEnvironment(mailHog, environment, properties);
        return mailHog;
    }

    private void registerMailHogEnvironment(GenericContainer<?> mailHog, ConfigurableEnvironment environment, MailHogProperties properties) {
        Integer smtpMappedPort = mailHog.getMappedPort(properties.getSmtpPort().intValue());
        Integer httpMappedPort = mailHog.getMappedPort(properties.getHttpPort().intValue());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.mailhog.host", mailHog.getHost());
        map.put("embedded.mailhog.smtp-port", smtpMappedPort);
        map.put("embedded.mailhog.http-port", httpMappedPort);
        map.put("embedded.mailhog.networkAlias", MAILHOG_NETWORK_ALIAS);
        map.put("embedded.mailhog.internalSmtpPort", properties.getSmtpPort());
        map.put("embedded.mailhog.internalHttpPort", properties.getHttpPort());
        log.info("Started MailHog. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedMailHogInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

