/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.mariadb;

import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.mariadb.MariaDBProperties;
import com.playtika.test.mariadb.MariaDBStatusCheck;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.WaitStrategy;

@Configuration
@Order(value=-2147483648)
@ConditionalOnProperty(name={"embedded.mariadb.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={MariaDBProperties.class})
public class EmbeddedMariaDBAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedMariaDBAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    MariaDBStatusCheck mariaDBStartupCheckStrategy(MariaDBProperties properties) {
        return new MariaDBStatusCheck();
    }

    @Bean(name={"embeddedMariaDb"}, destroyMethod="stop")
    public GenericContainer mariadb(ConfigurableEnvironment environment, MariaDBProperties properties, MariaDBStatusCheck mariaDBStatusCheck) throws Exception {
        log.info("Starting mariadb server. Docker image: {}", (Object)properties.dockerImage);
        GenericContainer mariadb = new GenericContainer(properties.dockerImage).withEnv("MYSQL_ALLOW_EMPTY_PASSWORD", "true").withEnv("MYSQL_USER", properties.getUser()).withEnv("MYSQL_PASSWORD", properties.getPassword()).withEnv("MYSQL_DATABASE", properties.getDatabase()).withCommand(new String[]{"--character-set-server=" + properties.getEncoding(), "--collation-server=" + properties.getCollation()}).withLogConsumer(ContainerUtils.containerLogsConsumer((Logger)log)).withExposedPorts(new Integer[]{properties.port}).waitingFor((WaitStrategy)mariaDBStatusCheck);
        mariadb.start();
        this.registerMariadbEnvironment(mariadb, environment, properties);
        return mariadb;
    }

    private void registerMariadbEnvironment(GenericContainer mariadb, ConfigurableEnvironment environment, MariaDBProperties properties) {
        Integer mappedPort = mariadb.getMappedPort(properties.port);
        String host = mariadb.getContainerIpAddress();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.mariadb.port", mappedPort);
        map.put("embedded.mariadb.host", host);
        map.put("embedded.mariadb.schema", properties.getDatabase());
        map.put("embedded.mariadb.user", properties.getUser());
        map.put("embedded.mariadb.password", properties.getPassword());
        String jdbcURL = "jdbc:mysql://{}:{}/{}";
        log.info("Started mariadb server. Connection details: {}, JDBC connection url: " + jdbcURL, new Object[]{map, host, mappedPort, properties.getDatabase()});
        MapPropertySource propertySource = new MapPropertySource("embeddedMariaInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

