/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.mariadb;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.mariadb.MariaDBProperties;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.MariaDBContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.mariadb.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={MariaDBProperties.class})
public class EmbeddedMariaDBBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedMariaDBBootstrapConfiguration.class);

    @Bean(name={"embeddedMariaDb"}, destroyMethod="stop")
    public MariaDBContainer mariadb(ConfigurableEnvironment environment, MariaDBProperties properties) throws Exception {
        log.info("Starting mariadb server. Docker image: {}", (Object)properties.dockerImage);
        MariaDBContainer mariadb = (MariaDBContainer)((MariaDBContainer)((MariaDBContainer)((MariaDBContainer)new MariaDBContainer(properties.dockerImage).withEnv("MYSQL_ALLOW_EMPTY_PASSWORD", "yes")).withUsername(properties.getUser()).withPassword(properties.getPassword()).withDatabaseName(properties.getDatabase()).withCommand(new String[]{"--character-set-server=" + properties.getEncoding(), "--collation-server=" + properties.getCollation(), "--max_allowed_packet=" + properties.getMaxAllowedPacket()})).withExposedPorts(new Integer[]{properties.port})).withInitScript(properties.initScriptPath);
        mariadb = (MariaDBContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)mariadb, (CommonContainerProperties)properties, (Logger)log);
        this.registerMariadbEnvironment(mariadb, environment, properties);
        return mariadb;
    }

    private void registerMariadbEnvironment(MariaDBContainer mariadb, ConfigurableEnvironment environment, MariaDBProperties properties) {
        Integer mappedPort = mariadb.getMappedPort(properties.port);
        String host = mariadb.getContainerIpAddress();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.mariadb.port", mappedPort);
        map.put("embedded.mariadb.host", host);
        map.put("embedded.mariadb.schema", properties.getDatabase());
        map.put("embedded.mariadb.user", properties.getUser());
        map.put("embedded.mariadb.password", properties.getPassword());
        String jdbcURL = "jdbc:mysql://{}:{}/{}";
        log.info("Started mariadb server. Connection details: {}, JDBC connection url: " + jdbcURL, new Object[]{map, host, mappedPort, properties.getDatabase()});
        MapPropertySource propertySource = new MapPropertySource("embeddedMariaInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

