/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.mariadb;

import com.playtika.test.common.operations.DefaultNetworkTestOperations;
import com.playtika.test.common.operations.NetworkTestOperations;
import com.playtika.test.common.properties.InstallPackageProperties;
import com.playtika.test.common.utils.AptGetPackageInstaller;
import com.playtika.test.common.utils.PackageInstaller;
import com.playtika.test.mariadb.MariaDBProperties;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.testcontainers.containers.GenericContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@ConditionalOnBean(value={MariaDBProperties.class})
@ConditionalOnProperty(value={"embedded.mariadb.enabled"}, matchIfMissing=true)
public class EmbeddedMariaDBTestOperationsAutoConfiguration {
    @Bean
    @ConfigurationProperties(value="embedded.mariadb.install")
    public InstallPackageProperties mariadbPackageProperties() {
        InstallPackageProperties properties = new InstallPackageProperties();
        properties.setPackages(Collections.singleton("iproute2"));
        return properties;
    }

    @Bean
    public PackageInstaller mariadbPackageInstaller(InstallPackageProperties mariadbPackageProperties, @Qualifier(value="embeddedMariaDb") GenericContainer mariadb) {
        return new AptGetPackageInstaller(mariadbPackageProperties, mariadb);
    }

    @Bean
    @ConditionalOnMissingBean(name={"mariadbNetworkTestOperations"})
    public NetworkTestOperations mariadbNetworkTestOperations(@Qualifier(value="embeddedMariaDb") GenericContainer mariadb) {
        return new DefaultNetworkTestOperations(mariadb);
    }
}

