/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.mariadb;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.mariadb.MariaDBProperties;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.util.LinkedHashMap;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.MariaDBContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.mariadb.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={MariaDBProperties.class})
public class EmbeddedMariaDBBootstrapConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedMariaDBBootstrapConfiguration.class);
    private static final String MARIADB_NETWORK_ALIAS = "mariadb.testcontainer.docker";

    @Bean
    @ConditionalOnToxiProxyEnabled(module="mariadb")
    ToxiproxyContainer.ContainerProxy mariadbContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedMariaDb") MariaDBContainer mariadbContainer, MariaDBProperties properties, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy((GenericContainer)mariadbContainer, properties.getPort());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.mariadb.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.mariadb.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.mariadb.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedMariadbToxiproxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started MariaDB ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean(name={"embeddedMariaDb"}, destroyMethod="stop")
    public MariaDBContainer mariadb(ConfigurableEnvironment environment, MariaDBProperties properties, Optional<Network> network) throws Exception {
        MariaDBContainer mariadb = (MariaDBContainer)((MariaDBContainer)((MariaDBContainer)((MariaDBContainer)((MariaDBContainer)new MariaDBContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withEnv("MYSQL_ALLOW_EMPTY_PASSWORD", "yes")).withUsername(properties.getUser()).withPassword(properties.getPassword()).withDatabaseName(properties.getDatabase()).withCommand(new String[]{"--character-set-server=" + properties.getEncoding(), "--collation-server=" + properties.getCollation(), "--max_allowed_packet=" + properties.getMaxAllowedPacket()})).withExposedPorts(new Integer[]{properties.getPort()})).withInitScript(properties.getInitScriptPath())).withNetworkAliases(new String[]{MARIADB_NETWORK_ALIAS});
        network.ifPresent(arg_0 -> ((MariaDBContainer)mariadb).withNetwork(arg_0));
        mariadb = (MariaDBContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)mariadb, (CommonContainerProperties)properties, (Logger)log);
        this.registerMariadbEnvironment(mariadb, environment, properties);
        return mariadb;
    }

    private void registerMariadbEnvironment(MariaDBContainer mariadb, ConfigurableEnvironment environment, MariaDBProperties properties) {
        Integer mappedPort = mariadb.getMappedPort(properties.getPort());
        String host = mariadb.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.mariadb.port", mappedPort);
        map.put("embedded.mariadb.host", host);
        map.put("embedded.mariadb.schema", properties.getDatabase());
        map.put("embedded.mariadb.user", properties.getUser());
        map.put("embedded.mariadb.password", properties.getPassword());
        map.put("embedded.mariadb.networkAlias", MARIADB_NETWORK_ALIAS);
        map.put("embedded.mariadb.internalPort", properties.getPort());
        String jdbcURL = "jdbc:mysql://{}:{}/{}";
        log.info("Started mariadb server. Connection details: {}, JDBC connection url: " + jdbcURL, new Object[]{map, host, mappedPort, properties.getDatabase()});
        MapPropertySource propertySource = new MapPropertySource("embeddedMariaInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

