/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.mariadb;

import com.playtika.testcontainer.common.properties.InstallPackageProperties;
import com.playtika.testcontainer.common.utils.AptGetPackageInstaller;
import com.playtika.testcontainer.common.utils.PackageInstaller;
import com.playtika.testcontainer.mariadb.MariaDBProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.testcontainers.containers.GenericContainer;

@AutoConfiguration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@ConditionalOnBean(value={MariaDBProperties.class})
@ConditionalOnProperty(value={"embedded.mariadb.enabled"}, matchIfMissing=true)
public class EmbeddedMariaDBTestOperationsAutoConfiguration {
    @Bean(value={"mariadbPackageProperties"})
    @ConfigurationProperties(value="embedded.mariadb.install")
    public InstallPackageProperties mariadbPackageProperties() {
        return new InstallPackageProperties();
    }

    @Bean
    public PackageInstaller mariadbPackageInstaller(@Qualifier(value="mariadbPackageProperties") InstallPackageProperties mariadbPackageProperties, @Qualifier(value="embeddedMariaDb") GenericContainer<?> mariadb) {
        return new AptGetPackageInstaller(mariadbPackageProperties, mariadb);
    }
}

