/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.memsql;

import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.memsql.MemSqlProperties;
import com.playtika.test.memsql.MemSqlStatusCheck;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.startupcheck.StartupCheckStrategy;

@Configuration
@Order(value=-2147483648)
@ConditionalOnProperty(name={"embedded.memsql.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={MemSqlProperties.class})
public class EmbeddedMemSqlAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedMemSqlAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    MemSqlStatusCheck memSqlStartupCheckStrategy(MemSqlProperties properties) {
        return new MemSqlStatusCheck();
    }

    @Bean(name={"embeddedMemsql"}, destroyMethod="stop")
    public GenericContainer memsql(ConfigurableEnvironment environment, MemSqlProperties properties, MemSqlStatusCheck memSqlStatusCheck) throws Exception {
        log.info("Starting memsql server. Docker image: {}", (Object)properties.dockerImage);
        GenericContainer memsql = new GenericContainer(properties.dockerImage).withEnv("IGNORE_MIN_REQUIREMENTS", "1").withStartupCheckStrategy((StartupCheckStrategy)memSqlStatusCheck).withLogConsumer(ContainerUtils.containerLogsConsumer((Logger)log)).withExposedPorts(new Integer[]{properties.port}).withClasspathResourceMapping("mem.sql", "/schema.sql", BindMode.READ_ONLY);
        memsql.start();
        this.registerMemSqlEnvironment(memsql, environment, properties);
        return memsql;
    }

    private void registerMemSqlEnvironment(GenericContainer memsql, ConfigurableEnvironment environment, MemSqlProperties properties) {
        Integer mappedPort = memsql.getMappedPort(properties.port);
        String host = memsql.getContainerIpAddress();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.memsql.port", mappedPort);
        map.put("embedded.memsql.host", host);
        map.put("embedded.memsql.schema", properties.getDatabase());
        map.put("embedded.memsql.user", properties.getUser());
        map.put("embedded.memsql.password", properties.getPassword());
        log.info("Started memsql server. Connection details {} ", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedMemSqlInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

