/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.memsql;

import com.github.dockerjava.api.model.Capability;
import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.memsql.MemSqlProperties;
import com.playtika.test.memsql.MemSqlStatusCheck;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.MountableFile;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.memsql.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={MemSqlProperties.class})
public class EmbeddedMemSqlBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedMemSqlBootstrapConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    MemSqlStatusCheck memSqlStartupCheckStrategy(MemSqlProperties properties) {
        return new MemSqlStatusCheck();
    }

    @Bean(name={"embeddedMemsql"}, destroyMethod="stop")
    public GenericContainer memsql(ConfigurableEnvironment environment, MemSqlProperties properties, MemSqlStatusCheck memSqlStatusCheck, @Autowired(required=false) Network network) {
        log.info("Starting memsql server. Docker image: {}", (Object)properties.dockerImage);
        GenericContainer memsql = new GenericContainer(properties.dockerImage).withEnv("IGNORE_MIN_REQUIREMENTS", "1").withExposedPorts(new Integer[]{properties.port}).withCopyFileToContainer(MountableFile.forClasspathResource((String)"mem.sql"), "/schema.sql").withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withCapAdd(new Capability[]{Capability.NET_ADMIN})).waitingFor((WaitStrategy)memSqlStatusCheck);
        if (network != null) {
            memsql = memsql.withNetwork(network);
        }
        memsql = ContainerUtils.configureCommonsAndStart((GenericContainer)memsql, (CommonContainerProperties)properties, (Logger)log);
        this.registerMemSqlEnvironment(memsql, environment, properties);
        return memsql;
    }

    private void registerMemSqlEnvironment(GenericContainer memsql, ConfigurableEnvironment environment, MemSqlProperties properties) {
        Integer mappedPort = memsql.getMappedPort(properties.port);
        String host = memsql.getContainerIpAddress();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.memsql.port", mappedPort);
        map.put("embedded.memsql.host", host);
        map.put("embedded.memsql.schema", properties.getDatabase());
        map.put("embedded.memsql.user", properties.getUser());
        map.put("embedded.memsql.password", properties.getPassword());
        log.info("Started memsql server. Connection details {} ", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedMemSqlInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

