/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.memsql;

import com.playtika.test.common.properties.InstallPackageProperties;
import com.playtika.test.common.utils.PackageInstaller;
import com.playtika.test.common.utils.YumPackageInstaller;
import com.playtika.test.memsql.MemSqlProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.testcontainers.containers.GenericContainer;

@AutoConfiguration
@ConditionalOnBean(value={MemSqlProperties.class})
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@ConditionalOnProperty(value={"embedded.memsql.enabled"}, matchIfMissing=true)
public class EmbeddedMemSqlTestOperationsAutoConfiguration {
    @Bean
    @ConfigurationProperties(value="embedded.memsql.install")
    public InstallPackageProperties memsqlPackageProperties() {
        InstallPackageProperties properties = new InstallPackageProperties();
        return properties;
    }

    @Bean
    public PackageInstaller memsqlPackageInstaller(InstallPackageProperties memsqlPackageProperties, @Qualifier(value="embeddedMemsql") GenericContainer<?> memsql) {
        return new YumPackageInstaller(memsqlPackageProperties, memsql);
    }
}

