/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.memsql;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.memsql.MemSqlProperties;
import com.playtika.testcontainer.memsql.MemSqlStatusCheck;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.MountableFile;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.memsql.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={MemSqlProperties.class})
public class EmbeddedMemSqlBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedMemSqlBootstrapConfiguration.class);
    private static final String MEMSQL_NETWORK_ALIAS = "memsql.testcontainer.docker";

    @Bean
    @ConditionalOnMissingBean
    MemSqlStatusCheck memSqlStartupCheckStrategy(MemSqlProperties properties) {
        return new MemSqlStatusCheck(properties);
    }

    @Bean
    @ConditionalOnToxiProxyEnabled(module="memsql")
    ToxiproxyContainer.ContainerProxy memsqlContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedMemsql") GenericContainer<?> memsql, MemSqlProperties properties, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy(memsql, properties.getPort());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.memsql.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.memsql.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.memsql.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedMemsqlToxiproxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started Memsql ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean(name={"embeddedMemsql"}, destroyMethod="stop")
    public GenericContainer<?> memsql(ConfigurableEnvironment environment, MemSqlProperties properties, MemSqlStatusCheck memSqlStatusCheck, Optional<Network> network) {
        GenericContainer memsql = new GenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withEnv("IGNORE_MIN_REQUIREMENTS", "1").withEnv("LICENSE_KEY", properties.getLicenseKey()).withEnv("SINGLESTORE_LICENSE", properties.getLicenseKey()).withEnv("ROOT_PASSWORD", properties.getPassword()).withEnv("START_AFTER_INIT", "Y").withExposedPorts(new Integer[]{properties.port}).withCopyFileToContainer(MountableFile.forClasspathResource((String)"mem.sql"), "/schema.sql").waitingFor((WaitStrategy)memSqlStatusCheck).withNetworkAliases(new String[]{MEMSQL_NETWORK_ALIAS});
        if ("aarch".equals(System.getProperty("system.arch"))) {
            memsql = memsql.withCommand(new String[]{"platform", "linux/amd64"});
        }
        network.ifPresent(arg_0 -> ((GenericContainer)memsql).withNetwork(arg_0));
        memsql = ContainerUtils.configureCommonsAndStart((GenericContainer)memsql, (CommonContainerProperties)properties, (Logger)log);
        this.registerMemSqlEnvironment(memsql, environment, properties);
        return memsql;
    }

    private void registerMemSqlEnvironment(GenericContainer<?> memsql, ConfigurableEnvironment environment, MemSqlProperties properties) {
        Integer mappedPort = memsql.getMappedPort(properties.port);
        String host = memsql.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.memsql.port", mappedPort);
        map.put("embedded.memsql.host", host);
        map.put("embedded.memsql.schema", properties.getDatabase());
        map.put("embedded.memsql.user", properties.getUser());
        map.put("embedded.memsql.password", properties.getPassword());
        map.put("embedded.memsql.networkAlias", MEMSQL_NETWORK_ALIAS);
        map.put("embedded.memsql.internalPort", properties.getPort());
        log.info("Started memsql server. Connection details {} ", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedMemSqlInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

