/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.minio;

import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.minio.MinioProperties;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@ConditionalOnProperty(value={"embedded.minio.enabled"}, matchIfMissing=true)
@Configuration
public class EmbeddedMinioBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedMinioBootstrapConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    MinioProperties minioProperties() {
        return new MinioProperties();
    }

    @Bean(name={"minioWaitStrategy"})
    @ConditionalOnMissingBean
    public WaitStrategy minioWaitStrategy(MinioProperties properties) {
        return new WaitAllStrategy().withStrategy((WaitStrategy)new HostPortWaitStrategy()).withStrategy((WaitStrategy)new HttpWaitStrategy().forPath("/minio/health/live").forPort(properties.port).forStatusCode(200)).withStartupTimeout(properties.getTimeoutDuration());
    }

    @Bean(name={"minio"}, destroyMethod="stop")
    public GenericContainer minio(WaitStrategy minioWaitStrategy, ConfigurableEnvironment environment, MinioProperties properties) {
        log.info("Starting Minio server. Docker image: {}", (Object)properties.dockerImage);
        GenericContainer minio = new GenericContainer(properties.dockerImage).withExposedPorts(new Integer[]{properties.port}).withLogConsumer(ContainerUtils.containerLogsConsumer((Logger)log)).withEnv("MINIO_ACCESS_KEY", properties.accessKey).withEnv("MINIO_SECRET_KEY", properties.secretKey).withEnv("MINIO_USERNAME", properties.userName).withEnv("MINIO_GROUPNAME", properties.groupName).withEnv("MINIO_REGION", properties.region).withEnv("MINIO_WORM", properties.worm).withEnv("MINIO_BROWSER", properties.browser).withCommand(new String[]{"server", properties.directory}).waitingFor(minioWaitStrategy).withStartupTimeout(properties.getTimeoutDuration());
        minio.start();
        this.registerEnvironment(minio, environment, properties);
        return minio;
    }

    private void registerEnvironment(GenericContainer container, ConfigurableEnvironment environment, MinioProperties properties) {
        Integer mappedPort = container.getMappedPort(properties.port);
        String host = container.getContainerIpAddress();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.minio.host", host);
        map.put("embedded.minio.port", mappedPort);
        map.put("embedded.minio.accessKey", properties.accessKey);
        map.put("embedded.minio.secretKey", properties.secretKey);
        map.put("embedded.minio.region", properties.region);
        log.info("Started Minio server. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedMinioInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

