/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.minio;

import com.playtika.test.common.properties.InstallPackageProperties;
import com.playtika.test.common.utils.MicroDnfPackageInstaller;
import com.playtika.test.common.utils.PackageInstaller;
import com.playtika.test.minio.MinioProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.testcontainers.containers.GenericContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@ConditionalOnBean(value={MinioProperties.class})
@ConditionalOnProperty(value={"embedded.minio.enabled"}, matchIfMissing=true)
public class EmbeddedMinioTestOperationsAutoConfiguration {
    @Bean
    @ConfigurationProperties(value="embedded.minio.install")
    InstallPackageProperties minioPackageProperties() {
        InstallPackageProperties properties = new InstallPackageProperties();
        return properties;
    }

    @Bean
    PackageInstaller minioPackageInstaller(InstallPackageProperties minioPackageProperties, @Qualifier(value="minio") GenericContainer<?> minio) {
        return new MicroDnfPackageInstaller(minioPackageProperties, minio);
    }
}

