/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.minio;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.minio.DefaultMinioWaitStrategy;
import com.playtika.test.minio.MinioProperties;
import com.playtika.test.minio.MinioWaitStrategy;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(value={"embedded.minio.enabled"}, matchIfMissing=true)
public class EmbeddedMinioBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedMinioBootstrapConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    MinioProperties minioProperties() {
        return new MinioProperties();
    }

    @Bean(name={"minioWaitStrategy"})
    @ConditionalOnMissingBean
    public MinioWaitStrategy minioWaitStrategy(MinioProperties properties) {
        return new DefaultMinioWaitStrategy(properties);
    }

    @Bean(name={"minio"}, destroyMethod="stop")
    public GenericContainer<?> minio(MinioWaitStrategy minioWaitStrategy, ConfigurableEnvironment environment, MinioProperties properties) {
        GenericContainer minio = new GenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withExposedPorts(new Integer[]{properties.port, properties.consolePort}).withEnv("MINIO_ROOT_USER", properties.accessKey).withEnv("MINIO_ROOT_PASSWORD", properties.secretKey).withEnv("MINIO_SITE_REGION", properties.region).withEnv("MINIO_WORM", properties.worm).withEnv("MINIO_BROWSER", properties.browser).withCommand(new String[]{"server", properties.directory, "--console-address", ":" + properties.consolePort}).waitingFor((WaitStrategy)minioWaitStrategy);
        minio = ContainerUtils.configureCommonsAndStart((GenericContainer)minio, (CommonContainerProperties)properties, (Logger)log);
        this.registerEnvironment(minio, environment, properties);
        return minio;
    }

    private void registerEnvironment(GenericContainer<?> container, ConfigurableEnvironment environment, MinioProperties properties) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.minio.host", container.getHost());
        map.put("embedded.minio.port", container.getMappedPort(properties.port));
        map.put("embedded.minio.consolePort", container.getMappedPort(properties.consolePort));
        map.put("embedded.minio.accessKey", properties.accessKey);
        map.put("embedded.minio.secretKey", properties.secretKey);
        map.put("embedded.minio.region", properties.region);
        log.info("Started Minio server. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedMinioInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

