/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.minio;

import com.playtika.testcontainer.common.properties.InstallPackageProperties;
import com.playtika.testcontainer.common.utils.MicroDnfPackageInstaller;
import com.playtika.testcontainer.common.utils.PackageInstaller;
import com.playtika.testcontainer.minio.MinioProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.testcontainers.containers.GenericContainer;

@AutoConfiguration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@ConditionalOnBean(value={MinioProperties.class})
@ConditionalOnProperty(value={"embedded.minio.enabled"}, matchIfMissing=true)
public class EmbeddedMinioTestOperationsAutoConfiguration {
    @Bean
    @ConfigurationProperties(value="embedded.minio.install")
    InstallPackageProperties minioPackageProperties() {
        return new InstallPackageProperties();
    }

    @Bean
    PackageInstaller minioPackageInstaller(InstallPackageProperties minioPackageProperties, @Qualifier(value="minio") GenericContainer<?> minio) {
        return new MicroDnfPackageInstaller(minioPackageProperties, minio);
    }
}

