/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.minio;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.minio.DefaultMinioWaitStrategy;
import com.playtika.testcontainer.minio.MinioProperties;
import com.playtika.testcontainer.minio.MinioWaitStrategy;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(value={"embedded.minio.enabled"}, matchIfMissing=true)
public class EmbeddedMinioBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedMinioBootstrapConfiguration.class);
    private static final String MINIO_NETWORK_ALIAS = "minio.testcontainer.docker";

    @Bean
    @ConditionalOnMissingBean
    MinioProperties minioProperties() {
        return new MinioProperties();
    }

    @Bean(name={"minioWaitStrategy"})
    @ConditionalOnMissingBean
    public MinioWaitStrategy minioWaitStrategy(MinioProperties properties) {
        return new DefaultMinioWaitStrategy(properties);
    }

    @Bean
    @ConditionalOnToxiProxyEnabled(module="minio")
    ToxiproxyContainer.ContainerProxy minioContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="minio") GenericContainer<?> minio, ConfigurableEnvironment environment, MinioProperties properties) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy(minio, properties.getPort());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.minio.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.minio.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.minio.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedMinioToxiproxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started Minio ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean(name={"minio"}, destroyMethod="stop")
    public GenericContainer<?> minio(MinioWaitStrategy minioWaitStrategy, ConfigurableEnvironment environment, MinioProperties properties, Optional<Network> network) {
        GenericContainer minio = new GenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withExposedPorts(new Integer[]{properties.getPort(), properties.getConsolePort()}).withEnv("MINIO_ROOT_USER", properties.getAccessKey()).withEnv("MINIO_ROOT_PASSWORD", properties.getSecretKey()).withEnv("MINIO_SITE_REGION", properties.getRegion()).withEnv("MINIO_WORM", properties.getWorm()).withEnv("MINIO_BROWSER", properties.getBrowser()).withCommand(new String[]{"server", properties.getDirectory(), "--console-address", ":" + properties.getConsolePort()}).waitingFor((WaitStrategy)minioWaitStrategy).withNetworkAliases(new String[]{MINIO_NETWORK_ALIAS});
        network.ifPresent(arg_0 -> ((GenericContainer)minio).withNetwork(arg_0));
        minio = ContainerUtils.configureCommonsAndStart((GenericContainer)minio, (CommonContainerProperties)properties, (Logger)log);
        this.registerEnvironment(minio, environment, properties);
        return minio;
    }

    private void registerEnvironment(GenericContainer<?> container, ConfigurableEnvironment environment, MinioProperties properties) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.minio.host", container.getHost());
        map.put("embedded.minio.port", container.getMappedPort(properties.port));
        map.put("embedded.minio.consolePort", container.getMappedPort(properties.consolePort));
        map.put("embedded.minio.accessKey", properties.accessKey);
        map.put("embedded.minio.secretKey", properties.secretKey);
        map.put("embedded.minio.region", properties.region);
        map.put("embedded.minio.networkAlias", MINIO_NETWORK_ALIAS);
        map.put("embedded.minio.internalPort", properties.getPort());
        map.put("embedded.minio.internalConsolePort", properties.getConsolePort());
        log.info("Started Minio server. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedMinioInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

