/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.mongodb;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.mongodb.MongodbProperties;
import com.playtika.test.mongodb.MongodbStatusCheck;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.mongodb.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={MongodbProperties.class})
public class EmbeddedMongodbBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedMongodbBootstrapConfiguration.class);

    @Bean(value={"embeddedMongodb"}, destroyMethod="stop")
    public GenericContainer mongodb(ConfigurableEnvironment environment, MongodbProperties properties, MongodbStatusCheck mongodbStatusCheck) {
        GenericContainer mongodb = new GenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withEnv("MONGO_INITDB_ROOT_USERNAME", properties.getUsername()).withEnv("MONGO_INITDB_ROOT_PASSWORD", properties.getPassword()).withEnv("MONGO_INITDB_DATABASE", properties.getDatabase()).withExposedPorts(new Integer[]{properties.getPort()}).waitingFor((WaitStrategy)mongodbStatusCheck);
        mongodb = ContainerUtils.configureCommonsAndStart((GenericContainer)mongodb, (CommonContainerProperties)properties, (Logger)log);
        this.registerMongodbEnvironment(mongodb, environment, properties);
        return mongodb;
    }

    @Bean
    @ConditionalOnMissingBean
    MongodbStatusCheck mongodbStartupCheckStrategy(MongodbProperties properties) {
        return new MongodbStatusCheck();
    }

    private void registerMongodbEnvironment(GenericContainer mongodb, ConfigurableEnvironment environment, MongodbProperties properties) {
        Integer mappedPort = mongodb.getMappedPort(properties.getPort());
        String host = mongodb.getContainerIpAddress();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.mongodb.port", mappedPort);
        map.put("embedded.mongodb.host", host);
        map.compute("embedded.mongodb.username", (k, v) -> properties.getUsername());
        map.compute("embedded.mongodb.password", (k, v) -> properties.getPassword());
        map.put("embedded.mongodb.database", properties.getDatabase());
        log.info("Started mongodb. Connection Details: {}, Connection URI: mongodb://{}:{}/{}", new Object[]{map, host, mappedPort, properties.getDatabase()});
        MapPropertySource propertySource = new MapPropertySource("embeddedMongoInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

