/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.mongodb;

import com.playtika.test.common.operations.DefaultNetworkTestOperations;
import com.playtika.test.common.operations.NetworkTestOperations;
import com.playtika.test.common.properties.InstallPackageProperties;
import com.playtika.test.common.utils.AptGetPackageInstaller;
import com.playtika.test.common.utils.PackageInstaller;
import com.playtika.test.mongodb.MongodbProperties;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.testcontainers.containers.GenericContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@ConditionalOnBean(value={MongodbProperties.class})
@ConditionalOnProperty(value={"embedded.mongodb.enabled"}, matchIfMissing=true)
public class EmbeddedMongodbTestOperationsAutoConfiguration {
    @Bean
    @ConfigurationProperties(value="embedded.mongodb.install")
    InstallPackageProperties mongodbPackageProperties() {
        InstallPackageProperties properties = new InstallPackageProperties();
        properties.setPackages(Collections.singleton("iproute2"));
        return properties;
    }

    @Bean
    PackageInstaller mongodbPackageInstaller(InstallPackageProperties mongodbPackageProperties, @Qualifier(value="embeddedMongodb") GenericContainer mongodb) {
        return new AptGetPackageInstaller(mongodbPackageProperties, mongodb);
    }

    @Bean
    @ConditionalOnMissingBean(name={"mongodbNetworkTestOperations"})
    public NetworkTestOperations mongodbNetworkTestOperations(@Qualifier(value="embeddedMongodb") GenericContainer mongodb) {
        return new DefaultNetworkTestOperations(mongodb);
    }
}

