/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.mongodb;

import com.playtika.testcontainer.common.properties.InstallPackageProperties;
import com.playtika.testcontainer.common.utils.AptGetPackageInstaller;
import com.playtika.testcontainer.common.utils.PackageInstaller;
import com.playtika.testcontainer.mongodb.MongodbProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.testcontainers.containers.GenericContainer;

@AutoConfiguration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@ConditionalOnBean(value={MongodbProperties.class})
@ConditionalOnProperty(value={"embedded.mongodb.enabled"}, matchIfMissing=true)
public class EmbeddedMongodbTestOperationsAutoConfiguration {
    @Bean(value={"mongodbPackageProperties"})
    @ConfigurationProperties(value="embedded.mongodb.install")
    public InstallPackageProperties mongodbPackageProperties() {
        return new InstallPackageProperties();
    }

    @Bean
    public PackageInstaller mongodbPackageInstaller(@Qualifier(value="mongodbPackageProperties") InstallPackageProperties mongodbPackageProperties, @Qualifier(value="embeddedMongodb") GenericContainer<?> mongodb) {
        return new AptGetPackageInstaller(mongodbPackageProperties, mongodb);
    }
}

