/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.mongodb;

import com.github.dockerjava.api.model.Capability;
import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="embedded.mongodb")
public class MongodbProperties
extends CommonContainerProperties {
    static final String BEAN_NAME_EMBEDDED_MONGODB = "embeddedMongodb";
    static final String BEAN_NAME_EMBEDDED_MONGODB_PACKAGE_PROPERTIES = "mongodbPackageProperties";
    private String host = "localhost";
    private int port = 27017;
    private String username;
    private String password;
    private String database = "test";
    private String[] checkCommand = new String[]{"mongosh", "admin", "--eval", "\"db['system.version'].find()\""};

    public MongodbProperties() {
        this.setCapabilities(Arrays.asList(Capability.NET_ADMIN));
    }

    public String getDefaultDockerImage() {
        return "mongo:7.0.11-jammy";
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.database;
    }

    public String[] getCheckCommand() {
        return this.checkCommand;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setCheckCommand(String[] checkCommand) {
        this.checkCommand = checkCommand;
    }

    public String toString() {
        return "MongodbProperties(host=" + this.getHost() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", database=" + this.getDatabase() + ", checkCommand=" + Arrays.deepToString(this.getCheckCommand()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MongodbProperties)) {
            return false;
        }
        MongodbProperties other = (MongodbProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        return Arrays.deepEquals(this.getCheckCommand(), other.getCheckCommand());
    }

    protected boolean canEqual(Object other) {
        return other instanceof MongodbProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPort();
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getCheckCommand());
        return result;
    }
}

