/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.mssqlserver;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.mssqlserver.EmbeddedMSSQLServerContainer;
import com.playtika.testcontainer.mssqlserver.MSSQLServerProperties;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.MSSQLServerContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.mssqlserver.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={MSSQLServerProperties.class})
public class EmbeddedMSSQLServerBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedMSSQLServerBootstrapConfiguration.class);
    private static final String MSSQLSERVER_NETWORK_ALIAS = "mssqlserver.testcontainer.docker";

    @Bean
    @ConditionalOnToxiProxyEnabled(module="mssqlserver")
    ToxiproxyContainer.ContainerProxy mssqlserverContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedMSSQLServer") EmbeddedMSSQLServerContainer mssqlserver, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy((GenericContainer)mssqlserver, MSSQLServerContainer.MS_SQL_SERVER_PORT.intValue());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.mssqlserver.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.mssqlserver.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.mssqlserver.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedMSSQLServerToxiproxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started MSSQLServer ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean(name={"embeddedMSSQLServer"}, destroyMethod="stop")
    public EmbeddedMSSQLServerContainer mssqlserver(ConfigurableEnvironment environment, MSSQLServerProperties properties, Optional<Network> network) {
        EmbeddedMSSQLServerContainer mssqlServerContainer = (EmbeddedMSSQLServerContainer)((EmbeddedMSSQLServerContainer)((EmbeddedMSSQLServerContainer)new EmbeddedMSSQLServerContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withPassword(properties.getPassword())).withInitScript(properties.getInitScriptPath())).withNetworkAliases(new String[]{MSSQLSERVER_NETWORK_ALIAS});
        network.ifPresent(arg_0 -> ((EmbeddedMSSQLServerContainer)mssqlServerContainer).withNetwork(arg_0));
        String startupLogCheckRegex = properties.getStartupLogCheckRegex();
        if (StringUtils.hasLength((String)startupLogCheckRegex)) {
            LogMessageWaitStrategy waitStrategy = new LogMessageWaitStrategy().withRegEx(startupLogCheckRegex);
            mssqlServerContainer.setWaitStrategy((WaitStrategy)waitStrategy);
        }
        if (properties.isAcceptLicence()) {
            mssqlServerContainer.acceptLicense();
        }
        mssqlServerContainer = (EmbeddedMSSQLServerContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)mssqlServerContainer, (CommonContainerProperties)properties, (Logger)log);
        this.registerMSSQLServerEnvironment(mssqlServerContainer, environment, properties);
        return mssqlServerContainer;
    }

    private void registerMSSQLServerEnvironment(MSSQLServerContainer<?> mssqlServerContainer, ConfigurableEnvironment environment, MSSQLServerProperties properties) {
        Integer mappedPort = mssqlServerContainer.getMappedPort(MSSQLServerContainer.MS_SQL_SERVER_PORT.intValue());
        String host = mssqlServerContainer.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.mssqlserver.port", mappedPort);
        map.put("embedded.mssqlserver.host", host);
        map.put("embedded.mssqlserver.database", "master");
        map.put("embedded.mssqlserver.user", "sa");
        map.put("embedded.mssqlserver.password", properties.getPassword());
        map.put("embedded.mssqlserver.networkAlias", MSSQLSERVER_NETWORK_ALIAS);
        map.put("embedded.mssqlserver.internalPort", MSSQLServerContainer.MS_SQL_SERVER_PORT);
        String jdbcURL = "jdbc:sqlserver://{}:{};databaseName={};trustServerCertificate=true";
        log.info("Started mssql server. Connection details: {}, JDBC connection url: " + jdbcURL, new Object[]{map, host, mappedPort, "master"});
        MapPropertySource propertySource = new MapPropertySource("embeddedMSSQLServerInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

