/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.mysql;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.mysql.MySQLProperties;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.MySQLContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.mysql.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={MySQLProperties.class})
public class EmbeddedMySQLBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedMySQLBootstrapConfiguration.class);

    @Bean(name={"embeddedMySQL"}, destroyMethod="stop")
    public MySQLContainer mysql(ConfigurableEnvironment environment, MySQLProperties properties) {
        MySQLContainer mysql = (MySQLContainer)((MySQLContainer)((MySQLContainer)((MySQLContainer)new MySQLContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withEnv("MYSQL_ALLOW_EMPTY_PASSWORD", "yes")).withUsername(properties.getUser()).withDatabaseName(properties.getDatabase()).withPassword(properties.getPassword()).withCommand(new String[]{"--character-set-server=" + properties.getEncoding(), "--collation-server=" + properties.getCollation()})).withExposedPorts(new Integer[]{properties.port})).withInitScript(properties.initScriptPath);
        mysql = (MySQLContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)mysql, (CommonContainerProperties)properties, (Logger)log);
        this.registerMySQLEnvironment(mysql, environment, properties);
        return mysql;
    }

    private void registerMySQLEnvironment(MySQLContainer mysql, ConfigurableEnvironment environment, MySQLProperties properties) {
        Integer mappedPort = mysql.getMappedPort(properties.port);
        String host = mysql.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.mysql.port", mappedPort);
        map.put("embedded.mysql.host", host);
        map.put("embedded.mysql.schema", properties.getDatabase());
        map.put("embedded.mysql.user", properties.getUser());
        map.put("embedded.mysql.password", properties.getPassword());
        String jdbcURL = "jdbc:mysql://{}:{}/{}";
        log.info("Started mysql server. Connection details: {}, JDBC connection url: " + jdbcURL, new Object[]{map, host, mappedPort, properties.getDatabase()});
        MapPropertySource propertySource = new MapPropertySource("embeddedMySQLInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

