/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.mysql;

import com.playtika.testcontainer.common.properties.InstallPackageProperties;
import com.playtika.testcontainer.common.utils.AptGetPackageInstaller;
import com.playtika.testcontainer.common.utils.PackageInstaller;
import com.playtika.testcontainer.mysql.MySQLProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.MySQLContainer;

@AutoConfiguration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@ConditionalOnBean(value={MySQLProperties.class})
@ConditionalOnProperty(value={"embedded.mysql.enabled"}, matchIfMissing=true)
public class EmbeddedMySQLTestOperationsAutoConfiguration {
    @Bean
    @ConfigurationProperties(value="embedded.mysql.install")
    public InstallPackageProperties mysqlPackageProperties() {
        return new InstallPackageProperties();
    }

    @Bean
    public PackageInstaller mysqlPackageInstaller(InstallPackageProperties mysqlPackageProperties, @Qualifier(value="embeddedMySQL") MySQLContainer mysql) {
        return new AptGetPackageInstaller(mysqlPackageProperties, (GenericContainer)mysql);
    }
}

