/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.mysql;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.mysql.MySQLProperties;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.util.LinkedHashMap;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.mysql.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={MySQLProperties.class})
public class EmbeddedMySQLBootstrapConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedMySQLBootstrapConfiguration.class);
    private static final String MYSQL_NETWORK_ALIAS = "mysql.testcontainer.docker";

    @Bean
    @ConditionalOnToxiProxyEnabled(module="mysql")
    ToxiproxyContainer.ContainerProxy mysqlContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedMySQL") MySQLContainer mysql, MySQLProperties properties, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy((GenericContainer)mysql, properties.getPort());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.mysql.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.mysql.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.mysql.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedMysqlToxiProxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Mysql ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean(name={"embeddedMySQL"}, destroyMethod="stop")
    public MySQLContainer mysql(ConfigurableEnvironment environment, MySQLProperties properties, Optional<Network> network) {
        MySQLContainer mysql = (MySQLContainer)((MySQLContainer)((MySQLContainer)((MySQLContainer)new MySQLContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withEnv("MYSQL_ALLOW_EMPTY_PASSWORD", "yes")).withUsername(properties.getUser()).withDatabaseName(properties.getDatabase()).withPassword(properties.getPassword()).withCommand(new String[]{"--character-set-server=" + properties.getEncoding(), "--collation-server=" + properties.getCollation()})).withInitScript(properties.getInitScriptPath())).withNetworkAliases(new String[]{MYSQL_NETWORK_ALIAS});
        network.ifPresent(arg_0 -> ((MySQLContainer)mysql).withNetwork(arg_0));
        mysql = (MySQLContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)mysql, (CommonContainerProperties)properties, (Logger)log);
        this.registerMySQLEnvironment(mysql, environment, properties);
        return mysql;
    }

    private void registerMySQLEnvironment(MySQLContainer mysql, ConfigurableEnvironment environment, MySQLProperties properties) {
        Integer mappedPort = mysql.getMappedPort(properties.getPort());
        String host = mysql.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.mysql.port", mappedPort);
        map.put("embedded.mysql.host", host);
        map.put("embedded.mysql.schema", properties.getDatabase());
        map.put("embedded.mysql.user", properties.getUser());
        map.put("embedded.mysql.password", properties.getPassword());
        map.put("embedded.mysql.networkAlias", MYSQL_NETWORK_ALIAS);
        map.put("embedded.mysql.internalPort", properties.getPort());
        String jdbcURL = "jdbc:mysql://{}:{}/{}";
        log.info("Started mysql server. Connection details: {}, JDBC connection url: " + jdbcURL, new Object[]{map, host, mappedPort, properties.getDatabase()});
        MapPropertySource propertySource = new MapPropertySource("embeddedMySQLInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

