/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.nativekafka.configuration;

import com.playtika.testcontainer.common.properties.InstallPackageProperties;
import com.playtika.testcontainer.common.utils.PackageInstaller;
import com.playtika.testcontainer.common.utils.YumPackageInstaller;
import com.playtika.testcontainer.nativekafka.properties.NativeKafkaConfigurationProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.testcontainers.containers.GenericContainer;

@AutoConfiguration
@ConditionalOnBean(value={NativeKafkaConfigurationProperties.class})
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@ConditionalOnProperty(value={"embedded.kafka.enabled"}, havingValue="true", matchIfMissing=true)
public class EmbeddedNativeKafkaTestOperationsAutoConfiguration {
    @Bean(value={"nativeKafkaPackageProperties"})
    @ConfigurationProperties(value="embedded.kafka.install")
    public InstallPackageProperties nativeKafkaPackageProperties() {
        return new InstallPackageProperties();
    }

    @Bean
    public PackageInstaller nativeKafkaPackageInstaller(@Qualifier(value="nativeKafkaPackageProperties") InstallPackageProperties nativeKafkaPackageProperties, @Qualifier(value="nativeKafka") GenericContainer<?> nativeKafka) {
        return new YumPackageInstaller(nativeKafkaPackageProperties, nativeKafka);
    }
}

