/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.nativekafka.properties;

import com.github.dockerjava.api.model.Capability;
import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="embedded.kafka")
public class NativeKafkaConfigurationProperties
extends CommonContainerProperties {
    public static final String NATIVE_KAFKA_BEAN_NAME = "nativeKafka";
    public static final String NATIVE_KAFKA_PACKAGE_PROPERTIES_BEAN_NAME = "nativeKafkaPackageProperties";
    protected String bootstrapServers;
    protected int kafkaPort = 9092;
    protected int socketTimeoutMs = 5000;
    protected int bufferSize = 65536;
    protected Collection<String> topicsToCreate = Collections.emptyList();
    protected Collection<TopicConfiguration> topicsConfiguration = Collections.emptyList();
    protected FileSystemBind fileSystemBind = new FileSystemBind();

    public NativeKafkaConfigurationProperties() {
        this.setCapabilities(List.of(Capability.NET_ADMIN));
    }

    public String getDefaultDockerImage() {
        return "apache/kafka-native:4.1.0";
    }

    @Generated
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    @Generated
    public int getKafkaPort() {
        return this.kafkaPort;
    }

    @Generated
    public int getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    @Generated
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Generated
    public Collection<String> getTopicsToCreate() {
        return this.topicsToCreate;
    }

    @Generated
    public Collection<TopicConfiguration> getTopicsConfiguration() {
        return this.topicsConfiguration;
    }

    @Generated
    public FileSystemBind getFileSystemBind() {
        return this.fileSystemBind;
    }

    @Generated
    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    @Generated
    public void setKafkaPort(int kafkaPort) {
        this.kafkaPort = kafkaPort;
    }

    @Generated
    public void setSocketTimeoutMs(int socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
    }

    @Generated
    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Generated
    public void setTopicsToCreate(Collection<String> topicsToCreate) {
        this.topicsToCreate = topicsToCreate;
    }

    @Generated
    public void setTopicsConfiguration(Collection<TopicConfiguration> topicsConfiguration) {
        this.topicsConfiguration = topicsConfiguration;
    }

    @Generated
    public void setFileSystemBind(FileSystemBind fileSystemBind) {
        this.fileSystemBind = fileSystemBind;
    }

    @Generated
    public String toString() {
        return "NativeKafkaConfigurationProperties(bootstrapServers=" + this.getBootstrapServers() + ", kafkaPort=" + this.getKafkaPort() + ", socketTimeoutMs=" + this.getSocketTimeoutMs() + ", bufferSize=" + this.getBufferSize() + ", topicsToCreate=" + String.valueOf(this.getTopicsToCreate()) + ", topicsConfiguration=" + String.valueOf(this.getTopicsConfiguration()) + ", fileSystemBind=" + String.valueOf(this.getFileSystemBind()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NativeKafkaConfigurationProperties)) {
            return false;
        }
        NativeKafkaConfigurationProperties other = (NativeKafkaConfigurationProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getKafkaPort() != other.getKafkaPort()) {
            return false;
        }
        if (this.getSocketTimeoutMs() != other.getSocketTimeoutMs()) {
            return false;
        }
        if (this.getBufferSize() != other.getBufferSize()) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        Collection<String> this$topicsToCreate = this.getTopicsToCreate();
        Collection<String> other$topicsToCreate = other.getTopicsToCreate();
        if (this$topicsToCreate == null ? other$topicsToCreate != null : !((Object)this$topicsToCreate).equals(other$topicsToCreate)) {
            return false;
        }
        Collection<TopicConfiguration> this$topicsConfiguration = this.getTopicsConfiguration();
        Collection<TopicConfiguration> other$topicsConfiguration = other.getTopicsConfiguration();
        if (this$topicsConfiguration == null ? other$topicsConfiguration != null : !((Object)this$topicsConfiguration).equals(other$topicsConfiguration)) {
            return false;
        }
        FileSystemBind this$fileSystemBind = this.getFileSystemBind();
        FileSystemBind other$fileSystemBind = other.getFileSystemBind();
        return !(this$fileSystemBind == null ? other$fileSystemBind != null : !((Object)this$fileSystemBind).equals(other$fileSystemBind));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NativeKafkaConfigurationProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getKafkaPort();
        result = result * 59 + this.getSocketTimeoutMs();
        result = result * 59 + this.getBufferSize();
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        Collection<String> $topicsToCreate = this.getTopicsToCreate();
        result = result * 59 + ($topicsToCreate == null ? 43 : ((Object)$topicsToCreate).hashCode());
        Collection<TopicConfiguration> $topicsConfiguration = this.getTopicsConfiguration();
        result = result * 59 + ($topicsConfiguration == null ? 43 : ((Object)$topicsConfiguration).hashCode());
        FileSystemBind $fileSystemBind = this.getFileSystemBind();
        result = result * 59 + ($fileSystemBind == null ? 43 : ((Object)$fileSystemBind).hashCode());
        return result;
    }

    public static final class FileSystemBind {
        private boolean enabled = false;
        private String dataFolder = "target/embedded-native-kafka-data";

        @Generated
        public FileSystemBind(boolean enabled, String dataFolder) {
            this.enabled = enabled;
            this.dataFolder = dataFolder;
        }

        @Generated
        public FileSystemBind() {
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public String getDataFolder() {
            return this.dataFolder;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setDataFolder(String dataFolder) {
            this.dataFolder = dataFolder;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileSystemBind)) {
                return false;
            }
            FileSystemBind other = (FileSystemBind)o;
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$dataFolder = this.getDataFolder();
            String other$dataFolder = other.getDataFolder();
            return !(this$dataFolder == null ? other$dataFolder != null : !this$dataFolder.equals(other$dataFolder));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $dataFolder = this.getDataFolder();
            result = result * 59 + ($dataFolder == null ? 43 : $dataFolder.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "NativeKafkaConfigurationProperties.FileSystemBind(enabled=" + this.isEnabled() + ", dataFolder=" + this.getDataFolder() + ")";
        }

        @Generated
        public FileSystemBind withEnabled(boolean enabled) {
            return this.enabled == enabled ? this : new FileSystemBind(enabled, this.dataFolder);
        }

        @Generated
        public FileSystemBind withDataFolder(String dataFolder) {
            return this.dataFolder == dataFolder ? this : new FileSystemBind(this.enabled, dataFolder);
        }
    }

    public static final class TopicConfiguration {
        private String topic;
        private int partitions;

        @Generated
        public TopicConfiguration(String topic, int partitions) {
            this.topic = topic;
            this.partitions = partitions;
        }

        @Generated
        public TopicConfiguration() {
        }

        @Generated
        public String getTopic() {
            return this.topic;
        }

        @Generated
        public int getPartitions() {
            return this.partitions;
        }

        @Generated
        public void setTopic(String topic) {
            this.topic = topic;
        }

        @Generated
        public void setPartitions(int partitions) {
            this.partitions = partitions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TopicConfiguration)) {
                return false;
            }
            TopicConfiguration other = (TopicConfiguration)o;
            if (this.getPartitions() != other.getPartitions()) {
                return false;
            }
            String this$topic = this.getTopic();
            String other$topic = other.getTopic();
            return !(this$topic == null ? other$topic != null : !this$topic.equals(other$topic));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPartitions();
            String $topic = this.getTopic();
            result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "NativeKafkaConfigurationProperties.TopicConfiguration(topic=" + this.getTopic() + ", partitions=" + this.getPartitions() + ")";
        }
    }
}

