/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.opensearch;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.opensearch.OpenSearchContainerFactory;
import com.playtika.testcontainer.opensearch.OpenSearchProperties;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.util.LinkedHashMap;
import java.util.Optional;
import lombok.Generated;
import org.opensearch.testcontainers.OpensearchContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.opensearch.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={OpenSearchProperties.class})
public class EmbeddedOpenSearchBootstrapConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedOpenSearchBootstrapConfiguration.class);
    private static final String OPENSEARCH_NETWORK_ALIAS = "opensearch.testcontainer.docker";

    @Bean
    @ConditionalOnToxiProxyEnabled(module="opensearch")
    ToxiproxyContainer.ContainerProxy opensearchContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedOpenSearch") OpensearchContainer opensearch, OpenSearchProperties properties, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy((GenericContainer)opensearch, properties.getHttpPort());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.opensearch.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.opensearch.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.opensearch.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedOpenSearchToxiproxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started OpenSearch ToxiProxy connection details {}", map);
        return proxy;
    }

    @ConditionalOnMissingBean(name={"embeddedOpenSearch"})
    @Bean(name={"embeddedOpenSearch"}, destroyMethod="stop")
    public GenericContainer openSearch(ConfigurableEnvironment environment, OpenSearchProperties properties, Optional<Network> network) {
        GenericContainer openSearch = OpenSearchContainerFactory.create(properties).withNetworkAliases(new String[]{OPENSEARCH_NETWORK_ALIAS});
        network.ifPresent(arg_0 -> ((GenericContainer)openSearch).withNetwork(arg_0));
        openSearch = ContainerUtils.configureCommonsAndStart((GenericContainer)openSearch, (CommonContainerProperties)properties, (Logger)log);
        this.registerOpenSearchEnvironment(openSearch, environment, properties);
        return openSearch;
    }

    private void registerOpenSearchEnvironment(GenericContainer openSearch, ConfigurableEnvironment environment, OpenSearchProperties properties) {
        Integer httpPort = openSearch.getMappedPort(properties.getHttpPort());
        Integer transportPort = openSearch.getMappedPort(properties.getTransportPort());
        String host = openSearch.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.opensearch.clusterName", properties.getClusterName());
        map.put("embedded.opensearch.host", host);
        map.put("embedded.opensearch.httpPort", httpPort);
        map.put("embedded.opensearch.transportPort", transportPort);
        map.put("embedded.opensearch.networkAlias", OPENSEARCH_NETWORK_ALIAS);
        map.put("embedded.opensearch.internalHttpPort", properties.getHttpPort());
        map.put("embedded.opensearch.internalTransportPort", properties.getTransportPort());
        log.info("Started OpenSearch server. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedOpenSearchInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

