/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.opensearch;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.opensearch.OpenSearchProperties;
import com.playtika.testcontainer.opensearch.rest.CreateIndex;
import com.playtika.testcontainer.opensearch.rest.WaitForGreenStatus;
import org.opensearch.testcontainers.OpensearchContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

class OpenSearchContainerFactory {
    OpenSearchContainerFactory() {
    }

    static GenericContainer create(OpenSearchProperties properties) {
        OpensearchContainer opensearchContainer = new OpensearchContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties));
        if (properties.isCredentialsEnabled()) {
            opensearchContainer.withSecurityEnabled();
        }
        return opensearchContainer.withExposedPorts(new Integer[]{properties.getHttpPort(), properties.getTransportPort()}).withEnv("cluster.name", properties.getClusterName()).withEnv("discovery.type", "single-node").withEnv("ES_JAVA_OPTS", OpenSearchContainerFactory.getJavaOpts(properties)).withEnv("OPENSEARCH_INITIAL_ADMIN_PASSWORD", properties.getPassword()).waitingFor(OpenSearchContainerFactory.getCompositeWaitStrategy(properties));
    }

    private static String getJavaOpts(OpenSearchProperties properties) {
        return "-Xms" + properties.getClusterRamMb() + "m -Xmx" + properties.getClusterRamMb() + "m";
    }

    private static WaitStrategy getCompositeWaitStrategy(OpenSearchProperties properties) {
        WaitAllStrategy strategy = new WaitAllStrategy().withStrategy((WaitStrategy)new HostPortWaitStrategy());
        properties.indices.forEach(index -> strategy.withStrategy((WaitStrategy)new CreateIndex(properties, (String)index)));
        return strategy.withStrategy((WaitStrategy)new WaitForGreenStatus(properties)).withStartupTimeout(properties.getTimeoutDuration());
    }
}

