/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.postgresql;

import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.postgresql.PostgreSQLProperties;
import com.playtika.test.postgresql.PostgreSQLStatusCheck;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.WaitStrategy;

@Configuration
@Order(value=-2147483648)
@ConditionalOnProperty(name={"embedded.postgresql.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={PostgreSQLProperties.class})
public class EmbeddedPostgreSQLBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedPostgreSQLBootstrapConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public PostgreSQLStatusCheck postgresSQLStartupCheckStrategy(PostgreSQLProperties properties) {
        return new PostgreSQLStatusCheck(properties);
    }

    @Bean(name={"embeddedPostgreSql"}, destroyMethod="stop")
    public GenericContainer postgresql(ConfigurableEnvironment environment, PostgreSQLProperties properties, PostgreSQLStatusCheck postgreSQLStatusCheck) {
        log.info("Starting postgresql server. Docker image: {}", (Object)properties.dockerImage);
        GenericContainer postgresql = new GenericContainer(properties.dockerImage).withEnv("POSTGRES_USER", properties.getUser()).withEnv("POSTGRES_PASSWORD", properties.getPassword()).withEnv("PGPASSWORD", properties.password).withEnv("POSTGRES_DB", properties.getDatabase()).withCommand("postgres").withLogConsumer(ContainerUtils.containerLogsConsumer((Logger)log)).withExposedPorts(new Integer[]{properties.port}).waitingFor((WaitStrategy)postgreSQLStatusCheck);
        postgresql.start();
        this.registerPostgresqlEnvironment(postgresql, environment, properties);
        return postgresql;
    }

    private void registerPostgresqlEnvironment(GenericContainer postgresql, ConfigurableEnvironment environment, PostgreSQLProperties properties) {
        Integer mappedPort = postgresql.getMappedPort(properties.port);
        String host = postgresql.getContainerIpAddress();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.postgresql.port", mappedPort);
        map.put("embedded.postgresql.host", host);
        map.put("embedded.postgresql.schema", properties.getDatabase());
        map.put("embedded.postgresql.user", properties.getUser());
        map.put("embedded.postgresql.password", properties.getPassword());
        String jdbcURL = "jdbc:postgresql://{}:{}/{}";
        log.info("Started postgresql server. Connection details: {}, JDBC connection url: " + jdbcURL, new Object[]{map, host, mappedPort, properties.getDatabase()});
        MapPropertySource propertySource = new MapPropertySource("embeddedPostgreInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

