/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.postgresql;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.postgresql.PostgreSQLProperties;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.utility.DockerImageName;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.postgresql.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={PostgreSQLProperties.class})
public class EmbeddedPostgreSQLBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedPostgreSQLBootstrapConfiguration.class);

    @Bean(name={"embeddedPostgreSql"}, destroyMethod="stop")
    public ConcretePostgreSQLContainer postgresql(ConfigurableEnvironment environment, PostgreSQLProperties properties) {
        log.info("Starting postgresql server. Docker image: {}", (Object)properties.dockerImage);
        ConcretePostgreSQLContainer postgresql = (ConcretePostgreSQLContainer)((ConcretePostgreSQLContainer)((ConcretePostgreSQLContainer)((ConcretePostgreSQLContainer)new ConcretePostgreSQLContainer(DockerImageName.parse((String)properties.dockerImage).asCompatibleSubstituteFor("postgres")).withUsername(properties.getUser())).withPassword(properties.getPassword())).withDatabaseName(properties.getDatabase())).withInitScript(properties.initScriptPath);
        postgresql = (ConcretePostgreSQLContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)postgresql, (CommonContainerProperties)properties, (Logger)log);
        this.registerPostgresqlEnvironment(postgresql, environment, properties);
        return postgresql;
    }

    private void registerPostgresqlEnvironment(ConcretePostgreSQLContainer postgresql, ConfigurableEnvironment environment, PostgreSQLProperties properties) {
        Integer mappedPort = postgresql.getMappedPort(PostgreSQLContainer.POSTGRESQL_PORT);
        String host = postgresql.getContainerIpAddress();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.postgresql.port", mappedPort);
        map.put("embedded.postgresql.host", host);
        map.put("embedded.postgresql.schema", properties.getDatabase());
        map.put("embedded.postgresql.user", properties.getUser());
        map.put("embedded.postgresql.password", properties.getPassword());
        String jdbcURL = "jdbc:postgresql://{}:{}/{}";
        log.info("Started postgresql server. Connection details: {}, JDBC connection url: " + jdbcURL, new Object[]{map, host, mappedPort, properties.getDatabase()});
        MapPropertySource propertySource = new MapPropertySource("embeddedPostgreInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }

    private static class ConcretePostgreSQLContainer
    extends PostgreSQLContainer<ConcretePostgreSQLContainer> {
        public ConcretePostgreSQLContainer(DockerImageName dockerImageName) {
            super(dockerImageName);
        }
    }
}

