/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.postgresql;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.postgresql.PostgreSQLProperties;
import com.playtika.test.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.postgresql.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={PostgreSQLProperties.class})
public class EmbeddedPostgreSQLBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedPostgreSQLBootstrapConfiguration.class);

    @Bean
    @ConditionalOnToxiProxyEnabled(module="postgresql")
    ToxiproxyContainer.ContainerProxy postgresqlContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedPostgreSql") PostgreSQLContainer postgresql, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy((GenericContainer)postgresql, PostgreSQLContainer.POSTGRESQL_PORT.intValue());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.postgresql.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.postgresql.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.postgresql.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedPostgresqlToxiproxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started Postgresql ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean(name={"embeddedPostgreSql"}, destroyMethod="stop")
    public PostgreSQLContainer postgresql(ConfigurableEnvironment environment, PostgreSQLProperties properties, Optional<Network> network) {
        PostgreSQLContainer postgresql = (PostgreSQLContainer)new PostgreSQLContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withUsername(properties.getUser()).withPassword(properties.getPassword()).withDatabaseName(properties.getDatabase()).withInitScript(properties.initScriptPath);
        network.ifPresent(arg_0 -> ((PostgreSQLContainer)postgresql).withNetwork(arg_0));
        String startupLogCheckRegex = properties.getStartupLogCheckRegex();
        if (StringUtils.hasLength((String)startupLogCheckRegex)) {
            LogMessageWaitStrategy waitStrategy = new LogMessageWaitStrategy().withRegEx(startupLogCheckRegex);
            postgresql.setWaitStrategy((WaitStrategy)waitStrategy);
        }
        postgresql = (PostgreSQLContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)postgresql, (CommonContainerProperties)properties, (Logger)log);
        this.registerPostgresqlEnvironment(postgresql, environment, properties);
        return postgresql;
    }

    private void registerPostgresqlEnvironment(PostgreSQLContainer postgresql, ConfigurableEnvironment environment, PostgreSQLProperties properties) {
        Integer mappedPort = postgresql.getMappedPort(PostgreSQLContainer.POSTGRESQL_PORT.intValue());
        String host = postgresql.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.postgresql.port", mappedPort);
        map.put("embedded.postgresql.host", host);
        map.put("embedded.postgresql.schema", properties.getDatabase());
        map.put("embedded.postgresql.user", properties.getUser());
        map.put("embedded.postgresql.password", properties.getPassword());
        String jdbcURL = "jdbc:postgresql://{}:{}/{}";
        log.info("Started postgresql server. Connection details: {}, JDBC connection url: " + jdbcURL, new Object[]{map, host, mappedPort, properties.getDatabase()});
        MapPropertySource propertySource = new MapPropertySource("embeddedPostgreInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

