/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.prometheus;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.prometheus.PrometheusProperties;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.prometheus.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={PrometheusProperties.class})
public class EmbeddedPrometheusBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedPrometheusBootstrapConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(name={"prometheusWaitStrategy"})
    public WaitStrategy prometheusWaitStrategy(PrometheusProperties properties) {
        return new HttpWaitStrategy().forPath("/status").forPort(properties.getPort()).forStatusCode(200);
    }

    @Bean(name={"prometheus"}, destroyMethod="stop")
    public GenericContainer prometheus(ConfigurableEnvironment environment, PrometheusProperties properties, WaitStrategy prometheusWaitStrategy) {
        GenericContainer container = new GenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withExposedPorts(new Integer[]{properties.getPort()}).withNetwork(Network.SHARED).withNetworkAliases(new String[]{properties.getNetworkAlias()}).waitingFor(prometheusWaitStrategy);
        ContainerUtils.configureCommonsAndStart((GenericContainer)container, (CommonContainerProperties)properties, (Logger)log);
        this.registerEnvironment(container, environment, properties);
        return container;
    }

    private void registerEnvironment(GenericContainer prometheus, ConfigurableEnvironment environment, PrometheusProperties properties) {
        Integer mappedPort = prometheus.getMappedPort(properties.port);
        String host = prometheus.getContainerIpAddress();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.prometheus.host", host);
        map.put("embedded.prometheus.port", mappedPort);
        log.info("Started Prometheus server. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedPrometheusInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

