/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.prometheus;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.prometheus.PrometheusProperties;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.prometheus.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={PrometheusProperties.class})
public class EmbeddedPrometheusBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedPrometheusBootstrapConfiguration.class);
    private static final String PROMETHEUS_NETWORK_ALIAS = "prometheus.testcontainer.docker";

    @Bean
    @ConditionalOnMissingBean(name={"prometheusWaitStrategy"})
    public WaitStrategy prometheusWaitStrategy(PrometheusProperties properties) {
        return new HttpWaitStrategy().forPath("/status").forPort(properties.getPort()).forStatusCode(200);
    }

    @Bean
    @ConditionalOnToxiProxyEnabled(module="prometheus")
    ToxiproxyContainer.ContainerProxy prometheusContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="prometheus") GenericContainer<?> prometheus, ConfigurableEnvironment environment, PrometheusProperties properties) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy(prometheus, properties.getPort());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.prometheus.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.prometheus.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.prometheus.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedPrometheusToxiproxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started Prometheus ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean(name={"prometheus"}, destroyMethod="stop")
    public GenericContainer<?> prometheus(ConfigurableEnvironment environment, PrometheusProperties properties, WaitStrategy prometheusWaitStrategy, Optional<Network> network) {
        GenericContainer container = new GenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withExposedPorts(new Integer[]{properties.getPort()}).withNetwork(Network.SHARED).withNetworkAliases(new String[]{properties.getNetworkAlias(), PROMETHEUS_NETWORK_ALIAS}).waitingFor(prometheusWaitStrategy);
        network.ifPresent(arg_0 -> ((GenericContainer)container).withNetwork(arg_0));
        ContainerUtils.configureCommonsAndStart((GenericContainer)container, (CommonContainerProperties)properties, (Logger)log);
        this.registerEnvironment(container, environment, properties);
        return container;
    }

    private void registerEnvironment(GenericContainer<?> prometheus, ConfigurableEnvironment environment, PrometheusProperties properties) {
        Integer mappedPort = prometheus.getMappedPort(properties.port);
        String host = prometheus.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.prometheus.host", host);
        map.put("embedded.prometheus.port", mappedPort);
        map.put("embedded.prometheus.staticNetworkAlias", PROMETHEUS_NETWORK_ALIAS);
        map.put("embedded.prometheus.internalPort", properties.getPort());
        log.info("Started Prometheus server. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedPrometheusInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

