/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.rabbitmq;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.rabbitmq.RabbitMQProperties;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.RabbitMQContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.rabbitmq.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={RabbitMQProperties.class})
public class EmbeddedRabbitMQBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedRabbitMQBootstrapConfiguration.class);

    @Bean(name={"embeddedRabbitMq"}, destroyMethod="stop")
    public RabbitMQContainer rabbitmq(ConfigurableEnvironment environment, RabbitMQProperties properties) {
        log.info("Starting RabbitMQ server. Docker image: {}", (Object)properties.getDockerImage());
        RabbitMQContainer rabbitMQ = (RabbitMQContainer)((RabbitMQContainer)new RabbitMQContainer(properties.getDockerImage()).withAdminPassword(properties.getPassword()).withEnv("RABBITMQ_DEFAULT_VHOST", properties.getVhost())).withExposedPorts(new Integer[]{properties.getPort(), properties.getHttpPort()});
        rabbitMQ = (RabbitMQContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)rabbitMQ, (CommonContainerProperties)properties, (Logger)log);
        this.registerRabbitMQEnvironment(rabbitMQ, environment, properties);
        return rabbitMQ;
    }

    private void registerRabbitMQEnvironment(RabbitMQContainer rabbitMQ, ConfigurableEnvironment environment, RabbitMQProperties properties) {
        Integer mappedPort = rabbitMQ.getMappedPort(properties.getPort());
        Integer mappedHttpPort = rabbitMQ.getMappedPort(properties.getHttpPort());
        String host = rabbitMQ.getContainerIpAddress();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.rabbitmq.port", mappedPort);
        map.put("embedded.rabbitmq.host", host);
        map.put("embedded.rabbitmq.vhost", properties.getVhost());
        map.put("embedded.rabbitmq.user", rabbitMQ.getAdminUsername());
        map.put("embedded.rabbitmq.password", rabbitMQ.getAdminPassword());
        map.put("embedded.rabbitmq.httpPort", mappedHttpPort);
        log.info("Started RabbitMQ server. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedRabbitMqInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

