/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.redis;

import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.redis.RedisProperties;
import com.playtika.test.redis.RedisStatusCheck;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.startupcheck.StartupCheckStrategy;

@Configuration
@AutoConfigureOrder(value=-2147483648)
@ConditionalOnProperty(name={"embedded.redis.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={RedisProperties.class})
public class EmbeddedRedisAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedRedisAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    RedisStatusCheck redisStartupCheckStrategy(RedisProperties properties) {
        return new RedisStatusCheck();
    }

    @Bean(name={"embeddedRedis"}, destroyMethod="stop")
    public GenericContainer redis(ConfigurableEnvironment environment, RedisProperties properties, RedisStatusCheck redisStatusCheck) throws Exception {
        log.info("Starting redis server. Docker image: {}", (Object)properties.dockerImage);
        GenericContainer redis = new GenericContainer(properties.dockerImage).withStartupCheckStrategy((StartupCheckStrategy)redisStatusCheck).withLogConsumer(ContainerUtils.containerLogsConsumer((Logger)log)).withExposedPorts(new Integer[]{properties.port}).withEnv("REDIS_USER", properties.getUser()).withEnv("REDIS_PASSWORD", properties.getPassword()).withCommand(new String[]{"redis-server", "--requirepass", properties.getPassword()}).withClasspathResourceMapping("redis-health.sh", "/redis-health.sh", BindMode.READ_ONLY);
        redis.start();
        this.registerRedisEnvironment(redis, environment, properties);
        return redis;
    }

    private void registerRedisEnvironment(GenericContainer redis, ConfigurableEnvironment environment, RedisProperties properties) {
        Integer mappedPort = redis.getMappedPort(properties.port);
        String host = redis.getContainerIpAddress();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.redis.port", mappedPort);
        map.put("embedded.redis.host", host);
        map.put("embedded.redis.password", properties.getPassword());
        map.put("embedded.redis.user", properties.getUser());
        MapPropertySource propertySource = new MapPropertySource("embeddedRedisInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

