/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.redis;

import com.playtika.test.common.spring.DependsOnPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import redis.clients.jedis.Jedis;

@Configuration
@AutoConfigureOrder
@AutoConfigureAfter(name={"org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration"})
public class EmbeddedRedisDependenciesAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedRedisDependenciesAutoConfiguration.class);

    @Configuration
    @ConditionalOnClass(value={Jedis.class})
    public static class JedisDependencyContext {
        @Bean
        public BeanFactoryPostProcessor jedisDependencyPostProcessor() {
            return new DependsOnPostProcessor(Jedis.class, new String[]{"embeddedRedis"});
        }
    }

    @Configuration
    @ConditionalOnClass(value={RedisTemplate.class})
    public static class RedisTemplateDependencyContext {
        @Bean
        public BeanFactoryPostProcessor redisTemplateDependencyPostProcessor() {
            return new DependsOnPostProcessor(RedisTemplate.class, new String[]{"embeddedRedis"});
        }
    }

    @Configuration
    @ConditionalOnClass(value={RedisConnectionFactory.class})
    public static class RedisConnectionFactoryDependencyContext {
        @Bean
        public BeanFactoryPostProcessor redisConnectionFactoryDependencyPostProcessor() {
            return new DependsOnPostProcessor(RedisConnectionFactory.class, new String[]{"embeddedRedis"});
        }
    }
}

