/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.redis;

import com.google.common.base.Joiner;
import com.playtika.test.common.checks.AbstractRetryingWaitStrategy;
import com.playtika.test.redis.RedisProperties;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.ContainerLaunchException;
import redis.clients.jedis.Jedis;

public class RedisClusterStatusCheck
extends AbstractRetryingWaitStrategy {
    private static final Logger log = LoggerFactory.getLogger(RedisClusterStatusCheck.class);
    private final RedisProperties properties;

    protected void waitUntilReady() {
        try {
            super.waitUntilReady();
        }
        catch (ContainerLaunchException e) {
            this.logClusterInfo();
            throw e;
        }
    }

    protected boolean isReady() {
        try (Jedis jedis = new Jedis(this.properties.host, this.properties.port);){
            jedis.auth(this.properties.password);
            String clusterInfo = jedis.clusterInfo();
            boolean bl = clusterInfo.contains("cluster_state:ok");
            return bl;
        }
    }

    private void logClusterInfo() {
        try (Jedis jedis = new Jedis(this.properties.host, this.properties.port);){
            jedis.auth(this.properties.password);
            String clusterInfo = jedis.clusterInfo();
            String info = jedis.info();
            List config = jedis.configGet("*");
            String clusterNodes = jedis.clusterNodes();
            log.error("Cluster in failed state:\n-- cluster info:\n{}\n-- nodes:\n{}\n", new Object[]{"-- info:\n{}\n-- config:\n{}" + clusterInfo, clusterNodes, info, Joiner.on((String)"\n").join((Iterable)config)});
        }
    }

    public RedisClusterStatusCheck(RedisProperties properties) {
        this.properties = properties;
    }
}

