/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.redis;

import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.redis.EnvUtils;
import com.playtika.test.redis.RedisProperties;
import com.playtika.test.redis.wait.DefaultRedisClusterWaitStrategy;
import com.playtika.test.redis.wait.RedisClusterWaitStrategy;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.env.ConfigurableEnvironment;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.MountableFile;

@Configuration
@AutoConfigureOrder(value=-2147483648)
@Conditional(value={EmbeddedRedisClusterCondition.class})
@EnableConfigurationProperties(value={RedisProperties.class})
public class EmbeddedRedisClusterBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedRedisClusterBootstrapConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public RedisClusterWaitStrategy redisClusterWaitStrategy(RedisProperties properties) {
        return new DefaultRedisClusterWaitStrategy(properties);
    }

    @Bean(name={"embeddedRedis"}, destroyMethod="stop")
    public GenericContainer redis(ConfigurableEnvironment environment, RedisProperties properties, WaitStrategy redisClusterWaitStrategy) {
        log.info("Starting Redis cluster. Docker image: {}", (Object)properties.dockerImage);
        GenericContainer redis = new FixedHostPortGenericContainer(properties.dockerImage).withFixedExposedPort(properties.port, properties.port).withLogConsumer(ContainerUtils.containerLogsConsumer((Logger)log)).withEnv("REDIS_USER", properties.getUser()).withEnv("REDIS_PASSWORD", properties.getPassword()).withCopyFileToContainer(MountableFile.forClasspathResource((String)"redis-cluster.conf"), "/data/redis-cluster.conf").withCopyFileToContainer(MountableFile.forClasspathResource((String)"nodes.conf"), "/data/nodes.conf").withCommand(new String[]{"redis-server", "/data/redis-cluster.conf", "--requirepass", properties.getPassword()}).waitingFor(redisClusterWaitStrategy).withStartupTimeout(properties.getTimeoutDuration());
        redis.start();
        Map<String, Object> redisEnv = EnvUtils.registerRedisEnvironment(environment, redis, properties, properties.port);
        log.info("Started Redis cluster. Connection details: {}", redisEnv);
        return redis;
    }

    static class EmbeddedRedisClusterCondition
    extends AllNestedConditions {
        public EmbeddedRedisClusterCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(name={"embedded.redis.clustered"}, havingValue="true")
        static class EmbeddedRedisClustered {
            EmbeddedRedisClustered() {
            }
        }

        @ConditionalOnProperty(name={"embedded.redis.enabled"}, matchIfMissing=true)
        static class EmbeddedRedisEnabled {
            EmbeddedRedisEnabled() {
            }
        }
    }
}

