/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.redis;

import com.playtika.test.common.operations.DefaultNetworkTestOperations;
import com.playtika.test.common.operations.NetworkTestOperations;
import com.playtika.test.common.properties.InstallPackageProperties;
import com.playtika.test.common.utils.ApkPackageInstaller;
import com.playtika.test.common.utils.PackageInstaller;
import com.playtika.test.redis.RedisProperties;
import java.util.Collections;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.testcontainers.containers.GenericContainer;

@Configuration
@ConditionalOnBean(value={RedisProperties.class})
@ConditionalOnProperty(value={"embedded.redis.enabled"}, matchIfMissing=true)
public class EmbeddedRedisTestOperationsAutoConfiguration {
    @Bean
    @ConfigurationProperties(value="embedded.redis.install")
    public InstallPackageProperties redisPackageProperties() {
        InstallPackageProperties properties = new InstallPackageProperties();
        properties.setPackages(Collections.singleton("iproute2"));
        return properties;
    }

    @Bean
    public PackageInstaller redisPackageInstaller(InstallPackageProperties redisPackageProperties, GenericContainer redis) {
        return new ApkPackageInstaller(redisPackageProperties, redis);
    }

    @Bean
    @ConditionalOnMissingBean(name={"redisNetworkTestOperations"})
    public NetworkTestOperations redisNetworkTestOperations(GenericContainer redis) {
        return new DefaultNetworkTestOperations(redis);
    }
}

