/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.redis;

import com.github.dockerjava.api.model.Capability;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.redis.EnvUtils;
import com.playtika.test.redis.RedisProperties;
import com.playtika.test.redis.wait.RedisStatusCheck;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.env.ConfigurableEnvironment;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@AutoConfigureOrder(value=-2147483648)
@Conditional(value={EmbeddedRedisCondition.class})
@EnableConfigurationProperties(value={RedisProperties.class})
public class EmbeddedRedisBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedRedisBootstrapConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public RedisStatusCheck redisStartupCheckStrategy() {
        return new RedisStatusCheck();
    }

    @Bean(name={"embeddedRedis"}, destroyMethod="stop")
    public GenericContainer redis(ConfigurableEnvironment environment, RedisProperties properties, RedisStatusCheck redisStatusCheck) {
        log.info("Starting Redis server. Docker image: {}", (Object)properties.dockerImage);
        GenericContainer redis = new GenericContainer(properties.dockerImage).withLogConsumer(ContainerUtils.containerLogsConsumer((Logger)log)).withExposedPorts(new Integer[]{properties.port}).withEnv("REDIS_USER", properties.getUser()).withEnv("REDIS_PASSWORD", properties.getPassword()).withCommand(new String[]{"redis-server", "--requirepass", properties.getPassword()}).withCreateContainerCmdModifier(cmd -> cmd.withCapAdd(new Capability[]{Capability.NET_ADMIN})).waitingFor((WaitStrategy)redisStatusCheck).withStartupTimeout(properties.getTimeoutDuration());
        redis.start();
        Map<String, Object> redisEnv = EnvUtils.registerRedisEnvironment(environment, redis, properties, redis.getMappedPort(properties.port));
        log.info("Started Redis server. Connection details: {}", redisEnv);
        return redis;
    }

    static class EmbeddedRedisCondition
    extends AllNestedConditions {
        public EmbeddedRedisCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(name={"embedded.redis.clustered"}, havingValue="false", matchIfMissing=true)
        static class EmbeddedRedisNotClustered {
            EmbeddedRedisNotClustered() {
            }
        }

        @ConditionalOnProperty(name={"embedded.redis.enabled"}, matchIfMissing=true)
        static class EmbeddedRedisEnabled {
            EmbeddedRedisEnabled() {
            }
        }
    }
}

