/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.redis;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.Capability;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.redis.EnvUtils;
import com.playtika.test.redis.FileUtils;
import com.playtika.test.redis.RedisProperties;
import com.playtika.test.redis.wait.DefaultRedisClusterWaitStrategy;
import com.playtika.test.redis.wait.RedisStatusCheck;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.ResourceLoader;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.MountableFile;

@Configuration
@AutoConfigureOrder(value=-2147483648)
@ConditionalOnProperty(name={"embedded.redis.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={RedisProperties.class})
public class EmbeddedRedisBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedRedisBootstrapConfiguration.class);
    public static final String REDIS_WAIT_STRATEGY_BEAN_NAME = "redisStartupCheckStrategy";
    private final ResourceLoader resourceLoader;

    @Bean(name={"redisStartupCheckStrategy"})
    @ConditionalOnMissingBean(name={"redisStartupCheckStrategy"})
    @ConditionalOnProperty(name={"embedded.redis.clustered"}, havingValue="false", matchIfMissing=true)
    public WaitStrategy redisStartupCheckStrategy(RedisProperties properties) {
        return new RedisStatusCheck(properties);
    }

    @Bean(name={"redisStartupCheckStrategy"})
    @ConditionalOnMissingBean(name={"redisStartupCheckStrategy"})
    @ConditionalOnProperty(name={"embedded.redis.clustered"}, havingValue="true")
    public WaitStrategy redisClusterWaitStrategy(RedisProperties properties) {
        return new DefaultRedisClusterWaitStrategy(properties);
    }

    @Bean(name={"embeddedRedis"}, destroyMethod="stop")
    public GenericContainer redis(ConfigurableEnvironment environment, RedisProperties properties, @Qualifier(value="redisStartupCheckStrategy") WaitStrategy redisStartupCheckStrategy) throws Exception {
        log.info("Starting Redis cluster. Docker image: {}", (Object)properties.dockerImage);
        this.prepareRedisConfFiles(properties);
        Consumer<CreateContainerCmd> containerCmdModifier = cmd -> cmd.withCapAdd(new Capability[]{Capability.NET_ADMIN});
        GenericContainer redis = new FixedHostPortGenericContainer(properties.dockerImage).withFixedExposedPort(properties.port, properties.port).withExposedPorts(new Integer[]{properties.port}).withLogConsumer(ContainerUtils.containerLogsConsumer((Logger)log)).withEnv("REDIS_USER", properties.getUser()).withEnv("REDIS_PASSWORD", properties.getPassword()).withCreateContainerCmdModifier(containerCmdModifier).withCopyFileToContainer(MountableFile.forClasspathResource((String)"redis.conf"), "/data/redis.conf").withCopyFileToContainer(MountableFile.forClasspathResource((String)"nodes.conf"), "/data/nodes.conf").withCommand(new String[]{"redis-server", "/data/redis.conf"}).waitingFor(redisStartupCheckStrategy).withStartupTimeout(properties.getTimeoutDuration());
        redis.start();
        Map<String, Object> redisEnv = EnvUtils.registerRedisEnvironment(environment, redis, properties, properties.port);
        log.info("Started Redis cluster. Connection details: {}", redisEnv);
        return redis;
    }

    private void prepareRedisConfFiles(RedisProperties properties) throws Exception {
        FileUtils.resolveTemplate(this.resourceLoader, "redis.conf", content -> content.replace("{{requirepass}}", properties.isRequirepass() ? "yes" : "no").replace("{{password}}", properties.isRequirepass() ? "requirepass " + properties.getPassword() : "").replace("{{clustered}}", properties.isClustered() ? "yes" : "no").replace("{{port}}", String.valueOf(properties.getPort())));
        FileUtils.resolveTemplate(this.resourceLoader, "nodes.conf", content -> content.replace("{{port}}", String.valueOf(properties.getPort())).replace("{{busPort}}", String.valueOf(properties.getPort() + 10000)));
    }

    public EmbeddedRedisBootstrapConfiguration(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

