/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.redis;

import com.playtika.test.redis.RedisProperties;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;

final class EnvUtils {
    static Map<String, Object> registerRedisEnvironment(ConfigurableEnvironment environment, GenericContainer redis, RedisProperties properties, int port) {
        String host = redis.getContainerIpAddress();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.redis.port", port);
        map.put("embedded.redis.host", host);
        map.put("embedded.redis.password", properties.getPassword());
        map.put("embedded.redis.user", properties.getUser());
        MapPropertySource propertySource = new MapPropertySource("embeddedRedisInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        return map;
    }

    private EnvUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

