/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.redis;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.common.utils.FileUtils;
import com.playtika.test.redis.EnvUtils;
import com.playtika.test.redis.RedisProperties;
import com.playtika.test.redis.wait.DefaultRedisClusterWaitStrategy;
import com.playtika.test.redis.wait.RedisStatusCheck;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.ResourceLoader;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.MountableFile;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.redis.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={RedisProperties.class})
public class EmbeddedRedisBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedRedisBootstrapConfiguration.class);
    public static final String REDIS_WAIT_STRATEGY_BEAN_NAME = "redisStartupCheckStrategy";
    private final ResourceLoader resourceLoader;
    private final RedisProperties properties;

    @Bean(name={"redisStartupCheckStrategy"})
    @ConditionalOnMissingBean(name={"redisStartupCheckStrategy"})
    @ConditionalOnProperty(name={"embedded.redis.clustered"}, havingValue="false", matchIfMissing=true)
    public WaitStrategy redisStartupCheckStrategy(RedisProperties properties) {
        return new RedisStatusCheck(properties);
    }

    @Bean(name={"redisStartupCheckStrategy"})
    @ConditionalOnMissingBean(name={"redisStartupCheckStrategy"})
    @ConditionalOnProperty(name={"embedded.redis.clustered"}, havingValue="true")
    public WaitStrategy redisClusterWaitStrategy(RedisProperties properties) {
        return new DefaultRedisClusterWaitStrategy(properties);
    }

    @Bean(name={"embeddedRedis"}, destroyMethod="stop")
    public GenericContainer redis(ConfigurableEnvironment environment, @Qualifier(value="redisStartupCheckStrategy") WaitStrategy redisStartupCheckStrategy) throws Exception {
        log.info("Starting Redis cluster. Docker image: {}", (Object)this.properties.getDockerImage());
        GenericContainer redis = new FixedHostPortGenericContainer(this.properties.getDockerImage()).withFixedExposedPort(this.properties.getPort(), this.properties.getPort()).withExposedPorts(new Integer[]{this.properties.getPort()}).withEnv("REDIS_USER", this.properties.getUser()).withEnv("REDIS_PASSWORD", this.properties.getPassword()).withCopyFileToContainer(MountableFile.forHostPath((Path)this.prepareRedisConf()), "/data/redis.conf").withCopyFileToContainer(MountableFile.forHostPath((Path)this.prepareNodesConf()), "/data/nodes.conf").withCommand(new String[]{"redis-server", "/data/redis.conf"}).waitingFor(redisStartupCheckStrategy);
        redis = ContainerUtils.configureCommonsAndStart((GenericContainer)redis, (CommonContainerProperties)this.properties, (Logger)log);
        Map<String, Object> redisEnv = EnvUtils.registerRedisEnvironment(environment, redis, this.properties, this.properties.getPort());
        log.info("Started Redis cluster. Connection details: {}", redisEnv);
        return redis;
    }

    private Path prepareRedisConf() throws IOException {
        return FileUtils.resolveTemplateAsPath((ResourceLoader)this.resourceLoader, (String)"redis.conf", content -> content.replace("{{requirepass}}", this.properties.isRequirepass() ? "yes" : "no").replace("{{password}}", this.properties.isRequirepass() ? "requirepass " + this.properties.getPassword() : "").replace("{{clustered}}", this.properties.isClustered() ? "yes" : "no").replace("{{port}}", String.valueOf(this.properties.getPort())));
    }

    private Path prepareNodesConf() throws IOException {
        return FileUtils.resolveTemplateAsPath((ResourceLoader)this.resourceLoader, (String)"nodes.conf", content -> content.replace("{{port}}", String.valueOf(this.properties.getPort())).replace("{{busPort}}", String.valueOf(this.properties.getPort() + 10000)));
    }

    public EmbeddedRedisBootstrapConfiguration(ResourceLoader resourceLoader, RedisProperties properties) {
        this.resourceLoader = resourceLoader;
        this.properties = properties;
    }
}

