/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.redis;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.common.utils.FileUtils;
import com.playtika.testcontainer.redis.EnvUtils;
import com.playtika.testcontainer.redis.RedisProperties;
import com.playtika.testcontainer.redis.wait.DefaultRedisClusterWaitStrategy;
import com.playtika.testcontainer.redis.wait.RedisStatusCheck;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ResourceLoader;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.MountableFile;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.redis.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={RedisProperties.class})
public class EmbeddedRedisBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedRedisBootstrapConfiguration.class);
    public static final String REDIS_NETWORK_ALIAS = "redis.testcontainer.docker";
    public static final String REDIS_WAIT_STRATEGY_BEAN_NAME = "redisStartupCheckStrategy";
    private final ResourceLoader resourceLoader;
    private final RedisProperties properties;

    @Bean(name={"redisStartupCheckStrategy"})
    @ConditionalOnMissingBean(name={"redisStartupCheckStrategy"})
    @ConditionalOnProperty(name={"embedded.redis.clustered"}, havingValue="false", matchIfMissing=true)
    public WaitStrategy redisStartupCheckStrategy(RedisProperties properties) {
        return new RedisStatusCheck(properties);
    }

    @Bean(name={"redisStartupCheckStrategy"})
    @ConditionalOnMissingBean(name={"redisStartupCheckStrategy"})
    @ConditionalOnProperty(name={"embedded.redis.clustered"}, havingValue="true")
    public WaitStrategy redisClusterWaitStrategy(RedisProperties properties) {
        return new DefaultRedisClusterWaitStrategy(properties);
    }

    @Bean
    @ConditionalOnToxiProxyEnabled(module="redis")
    ToxiproxyContainer.ContainerProxy redisContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedRedis") GenericContainer<?> redis, RedisProperties properties, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy(redis, properties.getPort());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.redis.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.redis.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.redis.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedRedisToxiProxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started Redis ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean(name={"embeddedRedis"}, destroyMethod="stop")
    public GenericContainer<?> redis(ConfigurableEnvironment environment, @Qualifier(value="redisStartupCheckStrategy") WaitStrategy redisStartupCheckStrategy, Optional<Network> network) throws Exception {
        GenericContainer redis = new FixedHostPortGenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)this.properties).asCanonicalNameString()).withFixedExposedPort(this.properties.getPort(), this.properties.getPort()).withExposedPorts(new Integer[]{this.properties.getPort()}).withEnv("REDIS_USER", this.properties.getUser()).withEnv("REDIS_PASSWORD", this.properties.getPassword()).withCopyFileToContainer(MountableFile.forHostPath((Path)this.prepareRedisConf()), "/data/redis.conf").withCopyFileToContainer(MountableFile.forHostPath((Path)this.prepareNodesConf()), "/data/nodes.conf").withCommand(new String[]{"redis-server", "/data/redis.conf"}).waitingFor(redisStartupCheckStrategy).withNetworkAliases(new String[]{REDIS_NETWORK_ALIAS});
        network.ifPresent(arg_0 -> ((GenericContainer)redis).withNetwork(arg_0));
        redis = ContainerUtils.configureCommonsAndStart((GenericContainer)redis, (CommonContainerProperties)this.properties, (Logger)log);
        Map<String, Object> redisEnv = EnvUtils.registerRedisEnvironment(environment, redis, this.properties, this.properties.getPort());
        log.info("Started Redis cluster. Connection details: {}", redisEnv);
        return redis;
    }

    private Path prepareRedisConf() throws IOException {
        return FileUtils.resolveTemplateAsPath((ResourceLoader)this.resourceLoader, (String)"redis.conf", content -> content.replace("{{requirepass}}", this.properties.isRequirepass() ? "yes" : "no").replace("{{password}}", (CharSequence)(this.properties.isRequirepass() ? "requirepass " + this.properties.getPassword() : "")).replace("{{clustered}}", this.properties.isClustered() ? "yes" : "no").replace("{{port}}", String.valueOf(this.properties.getPort())));
    }

    private Path prepareNodesConf() throws IOException {
        return FileUtils.resolveTemplateAsPath((ResourceLoader)this.resourceLoader, (String)"nodes.conf", content -> content.replace("{{port}}", String.valueOf(this.properties.getPort())).replace("{{busPort}}", String.valueOf(this.properties.getPort() + 10000)));
    }

    public EmbeddedRedisBootstrapConfiguration(ResourceLoader resourceLoader, RedisProperties properties) {
        this.resourceLoader = resourceLoader;
        this.properties = properties;
    }
}

