/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.redis;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.utils.TcpPortAvailableUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="embedded.redis")
public class RedisProperties
extends CommonContainerProperties
implements InitializingBean {
    public static final String BEAN_NAME_EMBEDDED_REDIS = "embeddedRedis";
    public String user = "root";
    public String password = "passw";
    public String host = "localhost";
    public int port = 0;
    public boolean requirepass = true;
    public boolean clustered = false;

    public void afterPropertiesSet() {
        if (this.port == 0) {
            this.port = TcpPortAvailableUtils.findAvailableTcpPort((int)1024, (int)50000);
        }
    }

    public String getDefaultDockerImage() {
        return "redis:7.0.12-alpine";
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRequirepass() {
        return this.requirepass;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setRequirepass(boolean requirepass) {
        this.requirepass = requirepass;
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    public String toString() {
        return "RedisProperties(user=" + this.getUser() + ", password=" + this.getPassword() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", requirepass=" + this.isRequirepass() + ", clustered=" + this.isClustered() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisProperties)) {
            return false;
        }
        RedisProperties other = (RedisProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isRequirepass() != other.isRequirepass()) {
            return false;
        }
        if (this.isClustered() != other.isClustered()) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isRequirepass() ? 79 : 97);
        result = result * 59 + (this.isClustered() ? 79 : 97);
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }
}

