/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.selenium.testscope;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.testcontainers.lifecycle.TestDescription;
import org.testcontainers.lifecycle.TestLifecycleAware;

public class TestcontainerScope
implements Scope {
    public static final String NAME = "testcontainer";
    private static final String TEST_CONTAINER_CLASS = "org.testcontainers.containers.GenericContainer";
    private static final String[] BEAN_CLASSES = new String[]{"org.testcontainers.containers.GenericContainer"};
    private final Map<String, Object> instances = new HashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name, ObjectFactory<?> objectFactory) {
        Map<String, Object> map = this.instances;
        synchronized (map) {
            Object instance = this.instances.get(name);
            if (instance == null) {
                instance = objectFactory.getObject();
                this.instances.put(name, instance);
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(String name) {
        Map<String, Object> map = this.instances;
        synchronized (map) {
            return this.instances.remove(name);
        }
    }

    public void registerDestructionCallback(String name, Runnable callback) {
    }

    public Object resolveContextualObject(String key) {
        return null;
    }

    public String getConversationId() {
        return null;
    }

    static void registerWith(ConfigurableApplicationContext context) {
        if (!ClassUtils.isPresent((String)TEST_CONTAINER_CLASS, null)) {
            return;
        }
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (beanFactory.getRegisteredScope(NAME) == null) {
            beanFactory.registerScope(NAME, (Scope)new TestcontainerScope());
        }
        context.addBeanFactoryPostProcessor(TestcontainerScope::postProcessBeanFactory);
    }

    private static void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        for (String beanClass : BEAN_CLASSES) {
            for (String beanName : beanFactory.getBeanNamesForType(ClassUtils.resolveClassName((String)beanClass, null))) {
                BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
                if (StringUtils.hasLength((String)definition.getScope())) continue;
                definition.setScope(NAME);
            }
        }
    }

    static TestcontainerScope getFrom(ApplicationContext context) {
        if (context instanceof ConfigurableApplicationContext) {
            Scope scope = ((ConfigurableApplicationContext)context).getBeanFactory().getRegisteredScope(NAME);
            return scope instanceof TestcontainerScope ? (TestcontainerScope)scope : null;
        }
        return null;
    }

    public void afterTestMethod(TestContext testContext) {
        this.instances.values().stream().filter(TestLifecycleAware.class::isInstance).map(TestLifecycleAware.class::cast).forEach(value -> value.afterTest(this.testDescription(testContext), Optional.ofNullable(testContext.getTestException())));
    }

    private TestDescription testDescription(final TestContext testContext) {
        return new TestDescription(){

            public String getTestId() {
                return this.getFilesystemFriendlyName();
            }

            public String getFilesystemFriendlyName() {
                return testContext.getTestClass().getName() + "-" + testContext.getTestMethod().getName();
            }
        };
    }

    public void beforeTestMethod(TestContext testContext) {
        this.instances.values().stream().filter(TestLifecycleAware.class::isInstance).map(TestLifecycleAware.class::cast).forEach(value -> value.beforeTest(this.testDescription(testContext)));
    }
}

